/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.monitor;

import com.humuson.tms.watcher.monitor.ThresholdChecker;
import com.humuson.tms.watcher.util.ThresholdJmxConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActiveMqChecker
extends ThresholdChecker {
    private static final Logger log = LoggerFactory.getLogger(ActiveMqChecker.class);
    @Autowired
    private ThresholdJmxConfig thresholdJmxConfig;

    public boolean returnUseable() {
        return this.processThresholdMq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Object> getStatus() {
        ArrayList<Object> arrStatus = new ArrayList<Object>();
        boolean checkResult = true;
        arrStatus.add(checkResult);
        String errorMsg = null;
        List<Map<String, String>> jmx = this.thresholdJmxConfig.getJmx();
        for (Map<String, String> jmxMap : jmx) {
            JMXConnector jmxc = null;
            MBeanServerConnection connection = null;
            DestinationViewMBean mbView = null;
            try {
                JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + jmxMap.get("url").trim() + "/jmxrmi");
                HashMap<String, String[]> environment = new HashMap<String, String[]>();
                String[] creds = new String[]{jmxMap.get("user").trim(), jmxMap.get("pw").trim()};
                environment.put("jmx.remote.credentials", creds);
                jmxc = JMXConnectorFactory.connect(url, environment);
                connection = jmxc.getMBeanServerConnection();
                ObjectName nameConsumers = null;
                nameConsumers = new ObjectName("org.apache.activemq:type=Broker,brokerName=" + jmxMap.get("broker").trim());
                mbView = MBeanServerInvocationHandler.newProxyInstance(connection, nameConsumers, DestinationViewMBean.class, true);
                int memoryUsage = mbView.getMemoryPercentUsage();
                jmxMap.put("memoryUsage", memoryUsage + "");
                jmxMap.put("threshold", this.thresholdPer_mq + "");
                if (memoryUsage < this.thresholdPer_mq) continue;
                checkResult = false;
            }
            catch (Exception e) {
                checkResult = false;
                errorMsg = e.getMessage();
            }
            finally {
                if (jmxc != null) {
                    try {
                        jmxc.close();
                    }
                    catch (Exception e) {
                        log.error("jmx close Exception ", (Throwable)e);
                    }
                }
                jmxc = null;
                connection = null;
                mbView = null;
            }
        }
        arrStatus.add(jmx);
        arrStatus.set(0, checkResult);
        if (errorMsg != null) {
            arrStatus.add(errorMsg);
        }
        return arrStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processThresholdMq() {
        boolean checkResult = true;
        List<Map<String, String>> jmx = this.thresholdJmxConfig.getJmx();
        for (Map<String, String> jmxMap : jmx) {
            if (!checkResult) break;
            JMXConnector jmxc = null;
            MBeanServerConnection connection = null;
            ObjectName nameConsumers = null;
            DestinationViewMBean mbView = null;
            try {
                JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + jmxMap.get("url").trim() + "/jmxrmi");
                HashMap<String, String[]> environment = new HashMap<String, String[]>();
                String[] creds = new String[]{jmxMap.get("user").trim(), jmxMap.get("pw").trim()};
                environment.put("jmx.remote.credentials", creds);
                jmxc = JMXConnectorFactory.connect(url, environment);
                connection = jmxc.getMBeanServerConnection();
                nameConsumers = new ObjectName("org.apache.activemq:type=Broker,brokerName=" + jmxMap.get("broker").trim());
                mbView = MBeanServerInvocationHandler.newProxyInstance(connection, nameConsumers, DestinationViewMBean.class, true);
                int memoryUsage = mbView.getMemoryPercentUsage();
                if (memoryUsage >= this.thresholdPer_mq) {
                    log.error("[checkActiveMQ] WARNING!!  server {} broker {} memory used {} % limit {} %", new Object[]{jmxMap.get("url").trim(), jmxMap.get("broker").trim(), memoryUsage, this.thresholdPer_mq});
                    checkResult = false;
                    continue;
                }
                checkResult = true;
            }
            catch (Exception e) {
                checkResult = false;
                log.error("jmx mview {}", (Throwable)e);
            }
            finally {
                if (jmxc != null) {
                    try {
                        jmxc.close();
                    }
                    catch (Exception e) {
                        log.error("jmx close Exception ", (Throwable)e);
                    }
                }
                jmxc = null;
                connection = null;
                nameConsumers = null;
                mbView = null;
            }
        }
        return checkResult;
    }
}

