/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.file;

import com.humuson.tms.watcher.model.ScheduleInfo;
import com.humuson.tms.watcher.repository.dao.DefaultInfoDao;
import java.io.File;
import java.util.List;
import org.aspectj.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class FileDeleter {
    private static final Logger log = LoggerFactory.getLogger(FileDeleter.class);
    @Autowired
    DefaultInfoDao defaultInfoDao;

    public int deleteBySendId(String basePath, String sendId) throws Exception {
        int result = -1;
        File deleteFile = null;
        try {
            if (sendId != null && !sendId.trim().isEmpty()) {
                List<ScheduleInfo> schdList = this.defaultInfoDao.selectScheduleInfo(null, sendId);
                for (ScheduleInfo schdInfo : schdList) {
                    deleteFile = new File(basePath + File.separator + schdInfo.getWorkday() + File.separator + schdInfo.getSchdId());
                    result = this.delete(deleteFile);
                }
                int n = result;
                return n;
            }
            int schdList = result;
            return schdList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            deleteFile = null;
        }
    }

    public int deleteBySchdInfo(String basePath, String schdId, String workday) throws Exception {
        int result = -1;
        File deleteFile = null;
        try {
            if (schdId != null && !schdId.trim().isEmpty()) {
                if (workday != null && !workday.trim().isEmpty()) {
                    List<ScheduleInfo> schdList = this.defaultInfoDao.selectScheduleInfo(schdId, null);
                    workday = schdList.get(0).getWorkday();
                }
                basePath = basePath + File.separator + workday + File.separator + schdId;
                deleteFile = new File(basePath);
                int schdList = result = this.delete(deleteFile);
                return schdList;
            }
            int schdList = result;
            return schdList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            deleteFile = null;
        }
    }

    public int delete(File file) {
        boolean isFolder = file.isDirectory();
        int result = FileUtil.deleteContents((File)file);
        if (isFolder && file.delete()) {
            ++result;
        }
        return result;
    }

    public File checkPath(File path) {
        Assert.isTrue((boolean)path.exists(), (String)("Path '" + path + "' does not exist"));
        Assert.isTrue((boolean)path.canRead(), (String)("Path '" + path + "' cannot be read"));
        return path;
    }
}

