/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.crypto.HumusonDecryptor;
import com.humuson.tms.util.date.DateUtil;
import com.humuson.tms.watcher.model.ContentInfoModel;
import com.humuson.tms.watcher.model.InAppMsgModel;
import com.humuson.tms.watcher.model.MapperRequestModel;
import com.humuson.tms.watcher.model.MapperResponseModel;
import com.humuson.tms.watcher.repository.dao.PreviewDao;
import com.humuson.tms.watcher.service.CreateMapperRequestService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class ContentViewController {
    private Logger log = LoggerFactory.getLogger((String)"autoApiTraceLog");
    @Value(value="${tms.mapper.content-real-view-url}")
    private String mapperUrl;
    @Autowired
    @Qualifier(value="tmsRestTemplate")
    RestTemplate restTemplate;
    @Autowired
    PreviewDao previewDao;
    @Autowired
    @Qualifier(value="tmsObjectMapper")
    ObjectMapper objectMapper;
    @Autowired
    TmsCommonConfig tmsCommonConfig;
    @Autowired
    CreateMapperRequestService mpReqService;

    public String getMappingCompliteData(MapperRequestModel mpModel) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)mpModel);
    }

    @RequestMapping(name="/warcher/realView", method={RequestMethod.POST}, produces={"application/json"})
    public MapperResponseModel getMpResponce(@RequestBody Map<String, Object> params) {
        this.log.info("[WT] Review Process : WEB REQUEST ] {}", params);
        String result_str = null;
        boolean mpUse = true;
        MapperRequestModel.MapperRequestModelBuilder mpReqModelBuilder = MapperRequestModel.builder();
        String channelType = (String)params.get(Column.CHANNEL_TYPE);
        String encryptYn = null;
        ContentInfoModel contentData = null;
        MapperResponseModel result = null;
        List<InAppMsgModel> inAppDatas = null;
        Map<String, Object> schdData = null;
        Map<String, Object> targetData = null;
        Map<String, Object> channelData = null;
        long sendId = params.containsKey(Column.SEND_ID) ? Long.parseLong(String.valueOf(params.get(Column.SEND_ID))) : 0L;
        long schdId = params.containsKey(Column.SCHD_ID) ? Long.parseLong(String.valueOf(params.get(Column.SCHD_ID))) : 0L;
        try {
            schdData = this.previewDao.selectTargetSchd(schdId, sendId);
            this.log.info("[WT] Review Process : SCHD DATA ] {}", schdData);
            if (schdData.containsKey("CONTENT_ID")) {
                contentData = this.previewDao.selectTargetContent(Long.parseLong(schdData.get("CONTENT_ID").toString())).get(0);
                this.log.info("[WT] Review Process : CONTENT DATA ] {}", (Object)contentData);
            }
            if (schdData.containsKey("TARGET_ID")) {
                targetData = this.previewDao.selectTargetInfo(Long.parseLong(schdData.get("TARGET_ID").toString()));
                this.log.info("[WT] Review Process : TARGET DATA ] {}", targetData);
            }
            if (schdData.containsKey("CHANNEL_ID")) {
                channelData = this.previewDao.selectTargetChannelInfo(Long.parseLong(schdData.get("CHANNEL_ID").toString()));
                this.log.info("[WT] Review Process : CHANNEL DATA ] {}", channelData);
            }
            if (channelData.containsKey("CHANNEL_TYPE_SUB")) {
                mpReqModelBuilder.channelTypeSub(channelData.get("CHANNEL_TYPE_SUB").toString());
            }
            if (schdData.containsKey("ENCRYPT_YN") && schdData.get("ENCRYPT_YN") != null && !StringUtils.isEmpty((Object)schdData.get("ENCRYPT_YN").toString())) {
                encryptYn = schdData.get("ENCRYPT_YN").toString();
                mpReqModelBuilder.encryptYn(encryptYn);
            }
            if (targetData.containsKey("TARGET_ID")) {
                mpReqModelBuilder.targetId(targetData.get("TARGET_ID").toString());
            }
            if (targetData.containsKey("TARGET_TYPE")) {
                mpReqModelBuilder.targetType(targetData.get("TARGET_TYPE").toString());
            }
            mpReqModelBuilder = this.mpReqService.getTargetData(mpReqModelBuilder, params);
            if (channelType.equals("PU")) {
                inAppDatas = this.previewDao.selectTargetInAppMsg((String)params.get(Column.TMS_M_ID), schdId, sendId);
                if (inAppDatas.size() > 0) {
                    mpReqModelBuilder = this.mpReqService.getContentData(mpReqModelBuilder, inAppDatas.get(0));
                    mpUse = false;
                } else {
                    mpReqModelBuilder = this.mpReqService.getPushContentData(mpReqModelBuilder, contentData);
                }
            } else {
                mpReqModelBuilder = this.mpReqService.getContentData(mpReqModelBuilder, contentData);
            }
            mpReqModelBuilder = this.mpReqService.getMappingData(mpReqModelBuilder, params);
            if (encryptYn != null && "Y".equals(encryptYn)) {
                mpReqModelBuilder.targetEmail(HumusonDecryptor.decrypt((String)((String)params.get(Column.TMS_M_EMAIL)), (String)this.tmsCommonConfig.getHumusonKey()));
                mpReqModelBuilder.targetPhone(HumusonDecryptor.decrypt((String)((String)params.get(Column.TMS_M_PHONE)), (String)this.tmsCommonConfig.getHumusonKey()));
            }
        }
        catch (Exception e) {
            this.log.error("[WT] Review Process : sendId:{} / schdId:{} =>", new Object[]{sendId, schdId, e});
            result_str = e.getMessage();
        }
        MapperRequestModel mpRequest = mpReqModelBuilder.build();
        this.log.debug("[WT] Review Process : MP REQUEST ] {}", (Object)mpRequest);
        result = this.createRequest(mpRequest, mpUse, result_str);
        return result;
    }

    public MapperResponseModel createRequest(MapperRequestModel mpRequest, boolean isMpUsed, String result_str) {
        MapperResponseModel result = null;
        String request = null;
        if (isMpUsed) {
            try {
                request = this.objectMapper.writeValueAsString((Object)mpRequest);
                this.log.info("MP Requset : {}", (Object)request);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
                result = (MapperResponseModel)this.restTemplate.postForObject(this.mapperUrl, (Object)entity, MapperResponseModel.class, new Object[0]);
            }
            catch (Exception e) {
                this.log.error("[WT] REALVIEW Process : createReqyest() : {}", (Throwable)e);
                result_str = e.getMessage();
            }
        }
        if (StringUtils.isEmpty(result)) {
            MapperResponseModel.MapperResponseModelBuilder resultBuilder = MapperResponseModel.builder();
            resultBuilder.channelType(mpRequest.getChannelType());
            resultBuilder.channelTypeSub(mpRequest.getChannelType());
            resultBuilder.content(mpRequest.getContent());
            resultBuilder.switchFlag(mpRequest.getSwitchFlag());
            resultBuilder.pushType(mpRequest.getPushType());
            resultBuilder.type(mpRequest.getType());
            resultBuilder.targetId(mpRequest.getTargetId());
            resultBuilder.targetType(mpRequest.getTargetType());
            resultBuilder.memberId(mpRequest.getMemberId());
            resultBuilder.targetName(mpRequest.getTargetName());
            resultBuilder.sendId(mpRequest.getSendId());
            resultBuilder.encryptYn(mpRequest.getEncryptYn());
            resultBuilder.subject(mpRequest.getSubject());
            resultBuilder.pushMsg(mpRequest.getPushMsg());
            resultBuilder.pushImg(mpRequest.getPushImg());
            resultBuilder.pushType(mpRequest.getPushType());
            resultBuilder.resultTime(DateUtil.getFullDateDefaultFormat());
            if (StringUtils.isEmpty((Object)result_str)) {
                resultBuilder.resultCode("200");
                resultBuilder.resultMsg("SUCCESS");
            } else {
                resultBuilder.resultCode("900");
                resultBuilder.resultMsg(result_str);
            }
            result = resultBuilder.build();
        }
        this.log.info("[WT] Review Process : Result ] {}", result);
        return result;
    }
}

