/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.controller;

import com.humuson.tms.util.FileUtil;
import com.humuson.tms.watcher.model.BIZContentModel;
import com.humuson.tms.watcher.model.EmailContentModel;
import com.humuson.tms.watcher.model.PushContentModel;
import com.humuson.tms.watcher.model.SMSContentModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/content"})
public class ContentController {
    private static final Logger log = LoggerFactory.getLogger(ContentController.class);

    @GetMapping
    public Object getFullContent() {
        String key = null;
        return this.getEMContent(key);
    }

    @PostMapping(value={"/full"}, produces={"application/json; charset=utf8"})
    @ResponseBody
    public Object getContent(@RequestParam(name="ch", required=true) String channelType, @RequestParam(name="key", required=true) String key) {
        log.info("getContent ");
        switch (channelType) {
            case "EM": {
                return this.getEMContent(key);
            }
            case "SM": {
                return this.getSMContent(key);
            }
            case "KA": {
                return this.getKAContent(key);
            }
            case "PU": {
                return this.getPUContent(key);
            }
        }
        return null;
    }

    public EmailContentModel getEMContent(String key) {
        EmailContentModel emailContent = null;
        String fullContentUrl = "http://211.48.18.51:8090/TMS/htdocs/camp/20181102/407010/1/ljs_118338:4675471.html";
        String fullContentPath = "/Users/taez/logagent/log_test/8/ljs.html";
        String content = null;
        emailContent = new EmailContentModel();
        emailContent.setFull_content_url(fullContentUrl);
        emailContent.setFull_cotent_path(fullContentPath);
        try {
            content = this.createContent(fullContentPath, fullContentUrl, "UTF-8");
            log.info("content : {}", (Object)content);
            content = this.emailConvert(content);
            log.info("emailConvert content : {}", (Object)content);
            emailContent.setContent(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return emailContent;
    }

    public String createContent(String path, String url, String lang) throws Exception {
        String content = null;
        content = FileUtil.readLocal((String)path, (String)lang);
        return content;
    }

    public String emailConvert(String content) {
        String tempContent = null;
        if (content.indexOf("Content-Type: multipart/mixed") > -1) {
            try {
                int startBoun = content.indexOf("boundary=\"");
                int endBoun = content.substring(startBoun + 10).indexOf("\"");
                String boundary = "\u2014" + content.substring(startBoun + 10).substring(0, endBoun);
                String temp = content.substring(startBoun + 10).substring(endBoun + 1);
                int startBoun1 = temp.indexOf(boundary);
                String temp2 = temp.substring(startBoun1 + boundary.length());
                int endBoun1 = temp2.indexOf(boundary);
                String tempStr = temp2.substring(temp2.indexOf("Content-Transfer-Encoding: base64") + 33, endBoun1).replaceAll("\r\n", "");
                String decodeStr = "";
                byte[] decodeStrarr = Base64Utils.decode((byte[])tempStr.getBytes());
                decodeStr = new String(decodeStrarr);
                tempContent = decodeStr.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&amp;", "&").replaceAll("&quot;", "\"").replaceAll("&#39;", "'");
            }
            catch (Exception startBoun) {}
        } else {
            try {
                int start = content.indexOf("Content-Transfer-Encoding: base64");
                String tempStr = content.substring(start + 33).replace("\r\n", "");
                String decodeStr = "";
                byte[] decodeStrarr = Base64Utils.decode((byte[])tempStr.getBytes());
                decodeStr = new String(decodeStrarr);
                tempContent = decodeStr.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&amp;", "&").replaceAll("&quot;", "\"").replaceAll("&#39;", "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tempContent;
    }

    public SMSContentModel getSMContent(String key) {
        return new SMSContentModel();
    }

    public BIZContentModel getKAContent(String key) {
        return new BIZContentModel();
    }

    public PushContentModel getPUContent(String key) {
        return new PushContentModel();
    }
}

