/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.controller;

import com.google.gson.JsonObject;
import com.humuson.tms.config.Constants;
import com.humuson.tms.watcher.model.MonitorModel;
import com.humuson.tms.watcher.monitor.ActiveMqChecker;
import com.humuson.tms.watcher.monitor.HddChecker;
import com.humuson.tms.watcher.monitor.RedisChecker;
import com.humuson.tms.watcher.util.ApiMonitorConfig;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CommonMonitorController {
    private static final Logger log = LoggerFactory.getLogger(CommonMonitorController.class);
    @Autowired
    HddChecker hddChecker;
    @Autowired
    RedisChecker redisChecker;
    @Autowired
    ActiveMqChecker activeMqChecker;
    @Autowired
    ApiMonitorConfig apiMonitorConfig;
    private final String PROCESS_OK = "OK";
    private final String PROCESS_NO = "NO";
    private final String CHECK_HDD = "HDD";
    private final String CHECK_MG = "MG";
    private final String CHECK_MQ = "MQ";

    @ResponseBody
    @RequestMapping(value={"/watcher/monitor"})
    public MonitorModel getStatus(@RequestParam(name="daemon") String daemon, @RequestParam(name="process") String process) {
        MonitorModel response = new MonitorModel();
        JsonObject prams = new JsonObject();
        prams.addProperty("daemon", daemon);
        prams.addProperty("process", process);
        boolean monitorResult = true;
        if (daemon == null || "".equals(daemon) || process == null || "".equals(process)) {
            monitorResult = false;
        } else if (this.apiMonitorConfig == null || this.apiMonitorConfig.monitor == null || Constants.JobName.NOTHING.equals((Object)process)) {
            monitorResult = true;
        } else {
            String value = this.apiMonitorConfig.monitor.get(process);
            if (value != null && !"".equals(value.trim())) {
                if (value.contains("#")) {
                    value = value.substring(0, value.indexOf("#"));
                }
                if (value.contains("HDD")) {
                    monitorResult = this.hddChecker.returnFileUseable();
                    prams.addProperty("HDD", Boolean.valueOf(monitorResult));
                }
                if (value.contains("MG") && monitorResult) {
                    monitorResult = this.redisChecker.returnUseable();
                    prams.addProperty("MG", Boolean.valueOf(monitorResult));
                }
                if (value.contains("MQ") && monitorResult) {
                    monitorResult = this.activeMqChecker.returnUseable();
                    prams.addProperty("MQ", Boolean.valueOf(monitorResult));
                }
            } else {
                monitorResult = false;
            }
        }
        if (monitorResult) {
            response.setStatus("OK");
        } else {
            response.setStatus("NO");
        }
        response.setPrams(prams.toString());
        return response;
    }

    public File checkPath(File path) {
        Assert.isTrue((boolean)path.exists(), (String)("Path '" + path + "' does not exist"));
        Assert.isTrue((boolean)path.canRead(), (String)("Path '" + path + "' cannot be read"));
        return path;
    }

    public double getPercent(long total, long target) {
        return Math.round((double)target / (double)total * 100.0);
    }
}

