/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.controller;

import com.humuson.tms.watcher.file.FileDeleter;
import com.humuson.tms.watcher.file.FileLocalReader;
import com.humuson.tms.watcher.repository.dao.DefaultInfoDao;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CommonFileController {
    private static final Logger log = LoggerFactory.getLogger(CommonFileController.class);
    @Value(value="${tms.mapper.content-save-path}")
    protected String defaultContentPath;
    @Value(value="${tms.mapper.mapping-data-save-path}")
    protected String defaultMappingPath;
    private final String TYPE_CONTENT = "CONTENT";
    private final String TYPE_MAPPING = "MAPPING";
    @Autowired
    DefaultInfoDao defaultInfoDao;
    @Autowired
    FileDeleter fileDeleter;
    @Autowired
    @Qualifier(value="FileLocalReader")
    FileLocalReader fileLocalReader;

    @ResponseBody
    @RequestMapping(value={"/watcher/file"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public String deleteFile(@RequestParam(name="path", required=false) String path, @RequestParam(name="type", required=false) String fileType, @RequestParam(name="workday", required=false) String workday, @RequestParam(name="schdId", required=false) String schdId, @RequestParam(name="sendId", required=false) String sendId) {
        log.info("watcher - file : path {}", (Object)path);
        JSONObject returnObj = new JSONObject();
        try {
            returnObj.put("STATUS", (Object)"NO");
            int result = -1;
            File file = null;
            if (fileType != null && !fileType.trim().isEmpty()) {
                if (fileType.equalsIgnoreCase("CONTENT")) {
                    path = this.defaultContentPath;
                } else if (fileType.equalsIgnoreCase("MAPPING")) {
                    path = this.defaultMappingPath;
                }
                result = this.fileDeleter.deleteBySchdInfo(path, schdId, workday);
                result += this.fileDeleter.deleteBySendId(path, sendId);
            } else if (path != null && !path.trim().isEmpty()) {
                file = new File(path);
                result = this.fileDeleter.delete(file);
            }
            returnObj.put("DELETED_FILE", result);
            returnObj.put("STATUS", (Object)"OK");
        }
        catch (Exception e) {
            log.error("delete File list Error : {}", (Throwable)e);
        }
        log.error("result : {}", (Object)returnObj.toString());
        return returnObj.toString();
    }

    @ResponseBody
    @RequestMapping(value={"/watcher/file"}, method={RequestMethod.DELETE})
    public String deleteFile(@RequestParam(name="path", required=false) String path) {
        log.info("watcher - delete file : path {}", (Object)path);
        JSONObject returnObj = new JSONObject();
        try {
            returnObj.put("STATUS", (Object)"NO");
            if (path != null && !path.trim().isEmpty()) {
                this.deleteFiles(path);
            }
            returnObj.put("DELETED_PATH", (Object)path);
            returnObj.put("STATUS", (Object)"OK");
        }
        catch (Exception e) {
            log.error("delete File list Error : {}", (Throwable)e);
        }
        log.error("result : {}", (Object)returnObj.toString());
        return returnObj.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/watcher/file"}, method={RequestMethod.GET})
    public String getFile(@RequestParam(name="path") String path) throws FileNotFoundException, IOException, Exception {
        log.info("watcher - read file : path {}", (Object)path);
        File file = new File(path);
        try {
            if (!file.exists()) {
                throw new Exception("[ERROR] read file :Path '" + path + "' does not exist");
            }
            if (!file.canRead()) {
                throw new Exception("[ERROR] read file :Path '" + path + "' cannot be read");
            }
            if (file.isDirectory()) {
                throw new Exception("[ERROR] read file :Path '" + path + "' is directory. not Read ");
            }
            String string = this.fileLocalReader.read(path);
            return string;
        }
        finally {
            file = null;
        }
    }

    public void deleteFiles(String filePath) throws IOException {
        Path targetPath = Paths.get(filePath, new String[0]);
        Files.walkFileTree(targetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                file.toFile().delete();
                return FileVisitResult.CONTINUE;
            }
        });
        Files.walkFileTree(targetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                File targetDir = dir.toFile();
                File[] targetFiles = targetDir.listFiles();
                if (targetFiles.length == 0) {
                    targetDir.delete();
                }
                return FileVisitResult.CONTINUE;
            }
        });
        targetPath.toFile().delete();
    }
}

