/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.controller;

import com.humuson.tms.watcher.util.FileUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class ApiTesterController {
    private static final Logger log = LoggerFactory.getLogger(ApiTesterController.class);

    @ResponseBody
    @RequestMapping(value={"/watcher/apitester"})
    public void checkApi(@RequestParam(name="url") String url, @RequestParam(name="cycleCnt") int cycleCnt, @RequestParam(name="threadCnt") int threadCnt) {
        Thread t;
        int i;
        log.info("apitester start. parameter : url {} cycleCnt {} threadCnt {}", new Object[]{url, cycleCnt, threadCnt});
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (i = 0; i < threadCnt; ++i) {
            t = new Thread(new WebCallTest(i, cycleCnt, url));
            t.start();
            threads.add(t);
        }
        for (i = 0; i < threads.size(); ++i) {
            t = (Thread)threads.get(i);
            try {
                t.join();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.info("apitester end.");
    }

    public class WebCallTest
    implements Runnable {
        int seq;
        int cycleCnt;
        String url;

        public WebCallTest(int seq, int cycleCnt, String url) {
            this.seq = seq;
            this.cycleCnt = cycleCnt;
            this.url = url;
        }

        @Override
        public void run() {
            log.info("thread {} start. cycleCnt {} url {}", new Object[]{this.seq, this.cycleCnt, this.url});
            try {
                String resStr = null;
                for (int i = 0; i < this.cycleCnt; ++i) {
                    resStr = FileUtil.readUrl(this.url);
                    log.info("thread {} - {}", (Object)this.seq, (Object)resStr);
                }
            }
            catch (Exception e) {
                log.error("{}", (Throwable)e);
            }
            log.info("thread {} end.", (Object)this.seq);
        }
    }
}

