/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class CommonWatcherConfig {
    @Value(value="${tms.watcher.rest.read.timeout}")
    private int restReadTimeout;
    @Value(value="${tms.watcher.rest.connect.timeout}")
    private int restConnectTimeout;
    @Value(value="${tms.watcher.rest.client.maxconntotal}")
    private int maxconntotal;
    @Value(value="${tms.watcher.rest.client.maxconnperroute}")
    private int maxconnperroute;

    @Bean(name={"tmsRestTemplate"})
    public RestTemplate restTemplate() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setReadTimeout(this.restReadTimeout);
        factory.setConnectTimeout(this.restConnectTimeout);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setMaxConnTotal(this.maxconntotal).setMaxConnPerRoute(this.maxconnperroute).build();
        factory.setHttpClient((HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean(name={"tmsObjectMapper"})
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        return mapper;
    }
}

