/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.auto.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tms.adaptor.jdbc.mybatis.BatchSqlExecutor;
import com.humuson.tms.config.ChannelType;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.util.StringUtils;
import com.humuson.tms.util.date.DateUtil;
import com.humuson.tms.watcher.auto.api.dao.AutoCampaignDao;
import com.humuson.tms.watcher.util.FileUtil2;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AutoCampaignController {
    private Logger log = LoggerFactory.getLogger((String)"autoApiTraceLog");
    @Autowired
    public AutoCampaignDao autoCampaignDao;
    @Autowired
    BatchSqlExecutor<Map<String, Object>> sqlExecutor;
    @Value(value="${tms.watcher.api.channel.company.em}")
    String defaultCampanyEM;
    @Value(value="${tms.watcher.api.channel.company.sm}")
    String defaultCampanySM;
    @Value(value="${tms.watcher.api.channel.company.pu}")
    String defaultCampanyPU;
    @Value(value="${tms.watcher.api.channel.company.ka}")
    String defaultCampanyKA;
    @Value(value="${tms.watcher.api.channel.nls-lang.em}")
    String defaultNlsLangEM;
    @Value(value="${tms.watcher.api.channel.nls-lang.pu}")
    String defaultNlsLangPU;
    @Value(value="${tms.watcher.api.channel.channel-type-sub.pu}")
    String defaultChannelTypeSubPU;
    @Value(value="${tms.watcher.api.auto.content.path}")
    private String autoContentPath;
    @Value(value="${tms.watcher.api.auto.content.url}")
    private String autoContentUrl;
    @Value(value="${tms.watcher.api.web.encrypt.yn}")
    String encryptYn;
    @Value(value="${tms.watcher.api.auto.type}")
    String defaultType;

    @RequestMapping(value={"/watcher/auto/campaign"}, produces={"application/json;charset=UTF-8"}, method={RequestMethod.POST})
    @ResponseBody
    private ResponseEntity<String> autoCampaign(@RequestBody Map<String, String> params, HttpServletRequest request) throws UnsupportedEncodingException, JSONException {
        this.log.info("[API] autoCampaign Regist CALL method:[POST] IP:[{}] params : {}", (Object)request.getRemoteAddr(), params);
        HttpHeaders responseHeaders = new HttpHeaders();
        JSONObject result = new JSONObject();
        try {
            String emptyColumn = this.checkParameter(params);
            params = this.defaultValueSetting(params);
            if (!StringUtils.isNull((String)emptyColumn)) {
                this.log.error("[API] ERROR Parameter [{}] is Null : {}", (Object)emptyColumn);
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] Parameter Invalid Error [" + emptyColumn + "] isEmpty");
            } else if (this.checkSendId(params) > 0) {
                this.log.error("[API] SEND_ID Exists : sendId:[{}]", (Object)params.get(Column.SEND_ID));
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] SEND_ID Exists : authKey:[" + params.get(Column.SEND_ID) + "]");
            } else {
                List<Map<String, Object>> fatigueList;
                if (ChannelType.EMAIL.same((params = this.selectSiteInfo(params)).get(Column.CHANNEL_TYPE))) {
                    params.put(Column.NLS_LANG, params.get(Column.NLS_LANG).toLowerCase());
                }
                String channelType = params.get(Column.CHANNEL_TYPE);
                String siteId = String.valueOf(params.get(Column.SITE_ID));
                if (!StringUtils.isNull((String)params.get(Column.FATIGUE_YN)) && "Y".equalsIgnoreCase(params.get(Column.FATIGUE_YN)) && ((fatigueList = this.selectFatigueInfo(Integer.parseInt(siteId), channelType)) == null || fatigueList.size() == 0)) {
                    this.log.error("[API] Not Registed Fatigue info : siteId:[{}] channelType:[{}] ", (Object)siteId, (Object)channelType);
                    result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] Not Registed Fatigue info : siteId:[" + siteId + "] channelType:[" + channelType + "]");
                    return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                }
                if (StringUtils.isNull((String)params.get(Column.CHANNEL_TYPE_SUB)) && ChannelType.PUSH.same(channelType)) {
                    params.put(Column.CHANNEL_TYPE_SUB, this.defaultChannelTypeSubPU);
                    params.put(Column.CONTENT_TYPE, "T");
                }
                Map<String, Object> resParam = this.insertAutoMsg(params);
                HashMap<String, String> finalParam = new HashMap<String, String>();
                finalParam.put(Column.SEND_ID, String.valueOf(resParam.get(Column.SEND_ID)));
                finalParam.put(Column.REG_ID, String.valueOf(resParam.get(Column.REG_ID)));
                finalParam.put(Column.TYPE, String.valueOf(resParam.get(Column.TYPE)));
                result.put((Object)Column.SEND_ID, (Object)String.valueOf(resParam.get(Column.SEND_ID)));
                if (this.insertAutoMsgQuery(params) > 0) {
                    if (this.autoCampaignDao.updateSendInfo(String.valueOf(resParam.get(Column.SEND_ID))) > 0) {
                        if (this.autoCampaignDao.insertSendSubInfo(finalParam) > 0) {
                            result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "200", "SUCCESS");
                            this.log.info("[API] RESULT : {} SEND_ID : {}", (Object)"SUCCESS", resParam.get(Column.SEND_ID));
                        } else {
                            result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "400", "[API] SEND_SUB_INFO INSERT FAIL");
                        }
                    } else {
                        result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "400", "[API] SEND_INFO UPDATE FAIL");
                    }
                } else {
                    result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "400", "[API] TARGET_INFO/LINK_INFO/QUERY_INFO INSERT/UPDATE FAIL");
                }
            }
        }
        catch (Exception e) {
            this.log.error("[API] ERROR : {}", (Throwable)e);
            result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] Error : " + e.getMessage());
        }
        return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/watcher/auto/campaign/active"}, produces={"application/json;charset=UTF-8"}, method={RequestMethod.POST})
    @ResponseBody
    private ResponseEntity<String> autoCampaignActive(@RequestBody Map<String, String> params, HttpServletRequest request) {
        this.log.info("[API] autoCampaignActive check CALL  IP:[{}] params : {}", (Object)request.getRemoteAddr(), params);
        HttpHeaders responseHeaders = new HttpHeaders();
        JSONObject result = new JSONObject();
        String errorKey = "";
        if (StringUtils.isNull((String)params.get(Column.SEND_ID))) {
            errorKey = Column.SEND_ID;
        } else if (StringUtils.isNull((String)params.get(Column.SITE_KEY))) {
            errorKey = Column.SITE_KEY;
        }
        if (!StringUtils.isNull((String)errorKey)) {
            this.log.error("[API] parameter [{}] is Null", (Object)errorKey);
            result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] Parameter Invalid Error [" + errorKey + "] isEmpty");
            return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        params = this.defaultValueSetting(params);
        Map<String, Object> sendSubInfo = this.autoCampaignDao.selectSendSubInfo(params);
        String sendId = "";
        if (sendSubInfo.containsKey(Column.SEND_ID)) {
            if (StringUtils.isNull((String)String.valueOf(sendSubInfo.get(Column.SEND_ID)))) {
                this.log.error("[API] TMS_SEND_SUB_INFO sendId is Null : sendId : {}", (Object)params.get(Column.SEND_ID));
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] TMS_SEND_SUB_INFO sendId is Null");
                return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
        } else {
            this.log.error("[API] TMS_SEND_SUB_INFO sendId is Null : sendId : {}", (Object)params.get(Column.SEND_ID));
            result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] sendId is Null");
            return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        sendId = String.valueOf(sendSubInfo.get(Column.SEND_ID));
        String workDay = StringUtils.isNull((String)params.get(Column.WORKDAY)) ? DateUtil.getWorkday() : params.get(Column.WORKDAY);
        try {
            params = this.selectSiteInfo(params);
            Map<String, Object> sendInfo = this.autoCampaignDao.getSendInfoAndQueryRegisted(sendId);
            if (Integer.parseInt(String.valueOf(sendInfo.get(Column.SELECT_QUERY_COUNT))) != 1) {
                this.log.error("[API] \ub300\uc0c1\uc790 \ucffc\ub9ac\uac00 \uc5c6\uac70\ub098 2\uac1c\uc774\uc0c1 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4. sendId:{} / selectQueryCnt:{}", (Object)sendId, sendInfo.get(Column.SELECT_QUERY_COUNT));
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "\uae30\ud0c0 \uc5d0\ub7ec", "[API] \ub300\uc0c1\uc790 \ucffc\ub9ac\uac00 \uc5c6\uac70\ub098 2\uac1c\uc774\uc0c1 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.");
                return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            if (String.valueOf(sendInfo.get(Column.TRIGGER_METHOD)).equalsIgnoreCase(Constants.TriggerMethod.C5.name()) && Integer.parseInt(String.valueOf(sendInfo.get(Column.UPDATE_QUERY_COUNT))) < 1) {
                this.log.error("[API] \uc2e4\uc2dc\uac04 \uac80\uc0c9\uc758 \uacbd\uc6b0 \ucd5c\uc18c 1\uac1c \uc774\uc0c1\uc758 \uc5c5\ub370\uc774\ud2b8 \ucffc\ub9ac\uac00 \ub4f1\ub85d\ub418\uc5b4\uc57c \ud569\ub2c8\ub2e4  sendId:{} / updateQueryCnt:{}", (Object)sendId, sendInfo.get(Column.UPDATE_QUERY_COUNT));
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "\uae30\ud0c0 \uc5d0\ub7ec", "[API] \uc2e4\uc2dc\uac04 \uac80\uc0c9\uc758 \uacbd\uc6b0 \ucd5c\uc18c 1\uac1c \uc774\uc0c1\uc758 \uc5c5\ub370\uc774\ud2b8 \ucffc\ub9ac\uac00 \ub4f1\ub85d\ub418\uc5b4\uc57c \ud569\ub2c8\ub2e4");
                return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            String nowJobStatus = String.valueOf(sendInfo.get(Column.JOB_STATUS));
            String currentUseYn = String.valueOf(sendInfo.get(Column.CURRENT_USE_YN));
            if ("Y".equals(currentUseYn) && "30".equals(nowJobStatus)) {
                Map<String, Object> schdInfo = this.autoCampaignDao.selectSchdInfo(sendId, workDay);
                if (schdInfo.isEmpty() || StringUtils.isNull((String)String.valueOf(schdInfo.get(Column.SCHD_ID))) || StringUtils.isNull((String)String.valueOf(schdInfo.get(Column.JOB_STATUS)))) {
                    this.log.error("[API] SCHD_INFO \uc815\ubcf4\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.  sendId:{} / workDay:{}", (Object)sendId, (Object)workDay);
                    result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "\uae30\ud0c0 \uc5d0\ub7ec", "[API] SCHD_INFO \uc815\ubcf4\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                    return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                }
                String jobStatus = String.valueOf(schdInfo.get(Column.JOB_STATUS));
                String schdId = String.valueOf(schdInfo.get(Column.SCHD_ID));
                if (!("42".equals(jobStatus) || "41".equals(jobStatus) || "00".equals(jobStatus) || "00".equals(jobStatus) || "43".equals(jobStatus) || "99".equals(jobStatus))) {
                    this.log.info("[API] [SUCCESS] \ubc1c\uc1a1\uac00\ub2a5\ud55c \uc0c1\ud0dc\uc785\ub2c8\ub2e4.  sendId [{}] schdId [{}]", (Object)sendId, (Object)schdId);
                    result.put((Object)Column.SCHD_ID, (Object)schdId);
                    result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "200", "[API] [SUCCESS] \ubc1c\uc1a1\uac00\ub2a5\ud55c \uc0c1\ud0dc\uc785\ub2c8\ub2e4.");
                }
            } else {
                this.log.error("[API] \ud604\uc7ac \ubc1c\uc1a1\ud560 \uc218 \uc5c6\ub294 \uc0c1\ud0dc\uc785\ub2c8\ub2e4. sendId:[{}] SEND_INFO -> JobStatus:[{}]  currentUseYn:[{}]", new Object[]{sendId, nowJobStatus, currentUseYn});
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] \ubc1c\uc1a1\ud560 \uc218 \uc5c6\ub294 \uc0c1\ud0dc\uc785\ub2c8\ub2e4 sendId:[" + sendId + "] SEND_INFO -> JobStatus:[" + nowJobStatus + "]  currentUseYn:[" + currentUseYn + "]");
            }
        }
        catch (Exception e) {
            this.log.error("[API] \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. sendId:[{}] Detail:{}", (Object)sendId, (Object)e);
            result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. " + e.getMessage());
        }
        return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/watcher/auto/campaign/target"}, produces={"application/json;charset=UTF-8"}, method={RequestMethod.POST})
    @ResponseBody
    private ResponseEntity<String> autoCampaignRegistTarget(@RequestBody Map<String, String> params, HttpServletRequest request) {
        JSONObject result;
        HttpHeaders responseHeaders;
        block18: {
            this.log.info("[API] autoCampaignRegistTarget check CALL  IP:[{}] params : {}", (Object)request.getRemoteAddr(), params);
            responseHeaders = new HttpHeaders();
            result = new JSONObject();
            String errorKey = "";
            if (params.containsKey(Column.SEND_ID) || params.containsKey(Column.SITE_KEY) || params.containsKey(Column.TARGET)) {
                if (StringUtils.isNull((String)String.valueOf(params.get(Column.SEND_ID)))) {
                    errorKey = Column.SEND_ID;
                } else if (StringUtils.isNull((String)String.valueOf(params.get(Column.SITE_KEY)))) {
                    errorKey = Column.SITE_KEY;
                } else if (StringUtils.isNull((String)String.valueOf(params.get(Column.TARGET)))) {
                    errorKey = Column.TARGET;
                }
            } else {
                this.log.error("[API] Parameter Invalid Error");
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] Parameter Invalid Error");
                return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            if (!StringUtils.isNull((String)errorKey)) {
                this.log.error("[API] parameter [{}] is Null", (Object)errorKey);
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] Parameter Invalid Error [" + errorKey + "] isEmpty");
                return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            try {
                String workDay;
                params = this.defaultValueSetting(params);
                String sendId = String.valueOf(this.autoCampaignDao.selectSendSubInfo(params).get(Column.SEND_ID));
                String string = workDay = StringUtils.isNull((String)params.get(Column.WORKDAY)) ? DateUtil.getWorkday() : params.get(Column.WORKDAY);
                if (StringUtils.isNull((String)sendId)) {
                    this.log.error("[API] sendId is Null : sendId : {} siteKey:{}", (Object)params.get(Column.SEND_ID), (Object)params.get(Column.SITE_KEY));
                    result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] sendId is Null");
                    break block18;
                }
                Map<String, String> resultMap = new HashMap();
                ArrayList<Map<String, String>> targetList = new ArrayList<Map<String, String>>();
                JSONParser parser = new JSONParser();
                JSONObject jsonObj = null;
                String target = params.get(Column.TARGET);
                Object obj = parser.parse(target);
                JSONArray arr = (JSONArray)obj;
                for (int i = 0; i < arr.size(); ++i) {
                    jsonObj = (JSONObject)arr.get(i);
                    resultMap = (Map)new ObjectMapper().readValue(jsonObj.toJSONString(), Map.class);
                    if (!resultMap.containsKey(Column.REQ_UID)) {
                        this.log.info("[API] TARGET [REQ_UID] isEmpty  continue ...  sendId:{} ID:{}", (Object)sendId, resultMap.get(Column.ID));
                        continue;
                    }
                    resultMap.put(Column.SEND_ID, params.get(Column.SEND_ID));
                    resultMap.put(Column.WORKDAY, workDay);
                    if (!resultMap.containsKey(Column.CONTENT) && params.containsKey(Column.CONTENT)) {
                        resultMap.put(Column.CONTENT, params.get(Column.CONTENT));
                    }
                    if (!resultMap.containsKey(Column.ETC) && params.containsKey(Column.ETC)) {
                        resultMap.put(Column.ETC, params.get(Column.ETC));
                    }
                    targetList.add(resultMap);
                    this.log.info("[{}] resultMap : {} ", (Object)i, (Object)resultMap.toString());
                }
                if (targetList.size() > 0) {
                    try {
                        BatchSqlExecutor.TmsBatchSqlExecutorResponse resultClass = this.sqlExecutor.batchUpdateResponse("insertTmaUserList", targetList, true);
                        List failList = resultClass.getFails();
                        this.log.info("[API] [SUCCESS] \ub300\uc0c1\uc790 \ub4f1\ub85d\uc644\ub8cc \t \uc804\uccb4 [{}] \uc131\uacf5 [{}] \uc2e4\ud328 [{}]", new Object[]{targetList.size(), targetList.size() - failList.size(), failList.size()});
                        result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "200", "[API] [SUCCESS] \uc804\uccb4 [" + targetList.size() + "] \uc131\uacf5 [" + (targetList.size() - failList.size()) + "] \uc2e4\ud328 [" + failList.size() + "]");
                        break block18;
                    }
                    catch (Exception e) {
                        this.log.error("[ERROR] batch insert Exception :{}", (Throwable)e);
                        throw new Exception("[ERROR] batch insert Exception ");
                    }
                }
                this.log.error("[ERROR] \ub300\uc0c1\uc790\uac00 \uc874\uc7ac\ud558\uc9c0\uc54a\uc2b5\ub2c8\ub2e4. userCnt :[{}]", (Object)targetList.size());
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "400", "[API] \ub300\uc0c1\uc790\uac00 \uc874\uc7ac\ud558\uc9c0\uc54a\uc2b5\ub2c8\ub2e4. userCnt :[" + targetList.size() + "]");
            }
            catch (Exception e) {
                this.log.error("[API] \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. sendId:[{}] : {}", (Object)params.get(Column.SEND_ID), (Object)e);
                result = this.putApiDefaultData(result, DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"), "401", "[API] \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. " + e.getMessage());
            }
        }
        return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public String checkParameter(Map<String, String> model) {
        String errorKey = "";
        String channelType = model.get(Column.CHANNEL_TYPE);
        if (StringUtils.isNull((String)channelType)) {
            errorKey = Column.CHANNEL_TYPE;
            return errorKey;
        }
        if (ChannelType.EMAIL.same(channelType)) {
            if (StringUtils.isNull((String)model.get(Column.CONTENT))) {
                errorKey = Column.CONTENT;
            } else if (StringUtils.isNull((String)model.get(Column.CONTENT_TYPE))) {
                errorKey = Column.CONTENT_TYPE;
            } else if (StringUtils.isNull((String)model.get(Column.FROM_NAME))) {
                errorKey = Column.FROM_NAME;
            } else if (StringUtils.isNull((String)model.get(Column.FROM_EMAIL))) {
                errorKey = Column.FROM_EMAIL;
            } else if (StringUtils.isNull((String)model.get(Column.SUBJECT))) {
                errorKey = Column.SUBJECT;
            } else if (StringUtils.isNull((String)model.get(Column.RETURN_PATH))) {
                errorKey = Column.RETURN_PATH;
            } else if (StringUtils.isNull((String)model.get(Column.SECURE_YN))) {
                errorKey = Column.SECURE_YN;
            }
            if (StringUtils.isNull((String)errorKey)) {
                if ("Y".equals(model.get(Column.SECURE_YN))) {
                    if (StringUtils.isNull((String)model.get(Column.SECURE_INTRO_TEMPLATE))) {
                        errorKey = Column.SECURE_INTRO_TEMPLATE;
                    } else if (StringUtils.isNull((String)model.get(Column.SECURE_PWD))) {
                        errorKey = Column.SECURE_PWD;
                    }
                }
                if ("Y".equals(model.get(Column.SAFEMAIL_YN)) && StringUtils.isNull((String)model.get(Column.TEMPLATE_WIDTH))) {
                    errorKey = Column.TEMPLATE_WIDTH;
                }
            }
        } else if (ChannelType.SMS.same(channelType)) {
            if (StringUtils.isNull((String)model.get(Column.CONTENT))) {
                errorKey = Column.CONTENT;
            } else if (StringUtils.isNull((String)model.get(Column.CHANNEL_TYPE_SUB))) {
                errorKey = Column.CHANNEL_TYPE_SUB;
            } else if (StringUtils.isNull((String)model.get(Column.SWITCH_FLAG))) {
                errorKey = Column.SWITCH_FLAG;
            } else if (StringUtils.isNull((String)model.get(Column.FROM_NUMBER))) {
                errorKey = Column.FROM_NUMBER;
            }
            if (StringUtils.isNull((String)errorKey) && (ChannelType.LMS.same(model.get(Column.CHANNEL_TYPE_SUB)) || ChannelType.MMS.same(model.get(Column.CHANNEL_TYPE_SUB))) && StringUtils.isNull((String)model.get(Column.SUBJECT))) {
                errorKey = Column.SUBJECT;
            }
        } else if (ChannelType.PUSH.same(channelType)) {
            if (StringUtils.isNull((String)model.get(Column.TMA_APP_KEY))) {
                errorKey = Column.TMA_APP_KEY;
            } else if (StringUtils.isNull((String)model.get(Column.PUSH_TYPE))) {
                errorKey = Column.PUSH_TYPE;
            }
            if (StringUtils.isNull((String)errorKey) && !"OM".equals(model.get(Column.PUSH_TYPE))) {
                if (StringUtils.isNull((String)model.get(Column.PUSH_MSG))) {
                    errorKey = Column.PUSH_MSG;
                } else if (StringUtils.isNull((String)model.get(Column.SUBJECT))) {
                    errorKey = Column.SUBJECT;
                }
            }
            if (StringUtils.isNull((String)errorKey) && ("MP".equals(model.get(Column.PUSH_TYPE)) || "OM".equals(model.get(Column.PUSH_TYPE))) && StringUtils.isNull((String)model.get(Column.CONTENT))) {
                errorKey = Column.CONTENT;
            }
        } else if (ChannelType.KAKAO.same(channelType)) {
            if (StringUtils.isNull((String)model.get(Column.SWITCH_FLAG))) {
                errorKey = Column.SWITCH_FLAG;
            } else if (StringUtils.isNull((String)model.get(Column.TEMPLATE_CODE))) {
                errorKey = Column.TEMPLATE_CODE;
            } else if (StringUtils.isNull((String)model.get(Column.SENDER_KEY))) {
                errorKey = Column.SENDER_KEY;
            } else if (StringUtils.isNull((String)model.get(Column.CHANNEL_TYPE_SUB))) {
                errorKey = Column.CHANNEL_TYPE_SUB;
            }
            if (StringUtils.isNull((String)errorKey) && !"N".equals(model.get(Column.SWITCH_FLAG))) {
                if (StringUtils.isNull((String)model.get(Column.FROM_NUMBER))) {
                    errorKey = Column.FROM_NUMBER;
                } else if (StringUtils.isNull((String)model.get(Column.SUBJECT))) {
                    errorKey = Column.SUBJECT;
                }
            }
        }
        if (StringUtils.isNull((String)model.get(Column.SITE_KEY))) {
            errorKey = Column.SITE_KEY;
        } else if (StringUtils.isNull((String)model.get(Column.MSG_NAME))) {
            errorKey = Column.MSG_NAME;
        } else if (StringUtils.isNull((String)model.get(Column.CYCLE_TYPE))) {
            errorKey = Column.CYCLE_TYPE;
        }
        if (!StringUtils.isNull((String)errorKey)) {
            this.log.error("[ERROR] parameter [{}] is Null", (Object)errorKey);
        }
        return errorKey;
    }

    public Map<String, String> defaultValueSetting(Map<String, String> params) {
        if (params.containsKey(Column.TYPE)) {
            params.put(Column.TYPE, StringUtils.isNull((String)params.get(Column.TYPE)) ? this.defaultType : params.get(Column.TYPE));
        } else {
            params.put(Column.TYPE, this.defaultType);
        }
        if (params.containsKey(Column.NLS_LANG)) {
            String nlsLang = this.defaultNlsLangEM;
            if (ChannelType.EMAIL.same(params.get(Column.CHANNEL_TYPE))) {
                nlsLang = this.defaultNlsLangEM;
            } else if (ChannelType.PUSH.same(params.get(Column.CHANNEL_TYPE))) {
                nlsLang = this.defaultNlsLangPU;
            }
            params.put(Column.NLS_LANG, StringUtils.isNull((String)params.get(Column.NLS_LANG)) ? nlsLang : params.get(Column.NLS_LANG));
        } else {
            params.put(Column.TYPE, this.defaultType);
        }
        if (!params.containsKey(Column.FATIGUE_YN)) {
            params.put(Column.FATIGUE_YN, StringUtils.isNull((String)params.get(Column.FATIGUE_YN)) ? "N" : params.get(Column.FATIGUE_YN));
        } else {
            params.put(Column.FATIGUE_YN, "N");
        }
        if (!params.containsKey(Column.TRACKING_YN)) {
            if (!ChannelType.EMAIL.same(params.get(Column.CHANNEL_TYPE))) {
                params.put(Column.TRACKING_YN, "N");
            } else {
                params.put(Column.TRACKING_YN, "Y");
            }
        }
        return params;
    }

    public List<Map<String, Object>> selectFatigueInfo(int siteId, String channelType) {
        return this.autoCampaignDao.selectFatigueInfoByChannel(siteId, channelType);
    }

    public JSONObject putApiDefaultData(JSONObject result, String resultTime, String resultCode, String resultMsg) {
        result.put((Object)"RESULT_TIME", (Object)resultTime);
        result.put((Object)"RESULT_CODE", (Object)resultCode);
        result.put((Object)"RESULT_MSG", (Object)resultMsg);
        return result;
    }

    public Map<String, Object> insertAutoMsg(Map<String, String> param) {
        String cycleType;
        this.log.info("insertAutoMsg()... param: {}", param);
        param.put(Column.CAMP_NAME, "API\ub4f1\ub85d_CAMP_NAME");
        param.put(Column.CAMP_TYPE, "A");
        param.put(Column.MKT_YN, "N");
        if ("L".equals(param.get(Column.CONTENT_TYPE))) {
            param.put(Column.CONTENT_URL, param.get(Column.CONTENT));
        }
        param.put(Column.CHANNEL_MSG_NAME, param.get(Column.MSG_NAME));
        if (StringUtils.isEmpty((CharSequence)param.get(Column.DUPLICATION_YN))) {
            param.put(Column.DUPLICATION_YN, "N");
        }
        if (StringUtils.isEmpty((CharSequence)param.get(Column.SAFEMAIL_YN))) {
            param.put(Column.SAFEMAIL_YN, "N");
        }
        if (StringUtils.isEmpty((CharSequence)param.get(Column.SECURE_YN))) {
            param.put(Column.SECURE_YN, "N");
        }
        String channelType = param.get(Column.CHANNEL_TYPE);
        if (StringUtils.isEmpty((CharSequence)param.get(Column.TRACKING_YN))) {
            if (StringUtils.equals((CharSequence)"EM", (CharSequence)channelType) || StringUtils.equals((CharSequence)"PU", (CharSequence)channelType)) {
                param.put(Column.TRACKING_YN, "Y");
            } else {
                param.put(Column.TRACKING_YN, "N");
            }
        }
        switch (cycleType = param.get(Column.CYCLE_TYPE)) {
            case "01": {
                param.put(Column.TRIGGER_METHOD, Constants.TriggerMethod.C1.name());
                break;
            }
            case "02": {
                param.put(Column.TRIGGER_METHOD, Constants.TriggerMethod.C2.name());
                break;
            }
            case "03": {
                param.put(Column.TRIGGER_METHOD, Constants.TriggerMethod.C3.name());
                break;
            }
            case "04": {
                param.put(Column.TRIGGER_METHOD, Constants.TriggerMethod.C4.name());
                break;
            }
            case "05": {
                param.put(Column.TRIGGER_METHOD, Constants.TriggerMethod.C5.name());
                break;
            }
            case "88": {
                String authKey = UUID.randomUUID().toString().replaceAll("-", "");
                param.put(Column.AUTH_KEY, authKey.substring(0, 20));
                param.put(Column.TRIGGER_METHOD, Constants.TriggerMethod.F1.name());
                break;
            }
            case "99": {
                param.put(Column.TRIGGER_METHOD, Constants.TriggerMethod.C1.name());
            }
        }
        String company = param.get(Column.COMPANY);
        if (StringUtils.isNull((String)company)) {
            switch (channelType) {
                case "SM": {
                    company = this.defaultCampanySM;
                    break;
                }
                case "PU": {
                    company = this.defaultCampanyPU;
                    break;
                }
                case "KA": {
                    company = this.defaultCampanyKA;
                    break;
                }
                default: {
                    company = this.defaultCampanyEM;
                }
            }
        }
        param.put(Column.COMPANY, company);
        int count = 0;
        if (StringUtils.validString((String)param.get(Column.SEND_ID)).equals("")) {
            count += this.autoCampaignDao.insertCampInfo(param);
            count += this.autoCampaignDao.insertChannelInfo(param);
        }
        count += this.autoCampaignDao.insertTriggerInfo(param);
        count += this.autoCampaignDao.insertContentInfo(param);
        if (StringUtils.validString((String)param.get(Column.SEND_ID)).equals("")) {
            count += this.autoCampaignDao.insertSendInfo(param);
            count += this.autoCampaignDao.insertAdditionInfo(param);
            count += this.autoCampaignDao.insertControlInfo(param);
        } else {
            count += this.autoCampaignDao.updateAdditionInfo(param);
            count += this.autoCampaignDao.updateChannelInfo(param);
        }
        count += this.autoCampaignDao.updateSendInfoByJoinTable(param);
        if ((ChannelType.SMS.same(cycleType) || ChannelType.PUSH.same(cycleType)) && "88".equals(cycleType)) {
            count += this.autoCampaignDao.insertSendSubInfo(param);
        }
        if (StringUtils.equals((CharSequence)param.get(Column.SECURE_YN), (CharSequence)"Y")) {
            count += this.autoCampaignDao.insertUpdateSecuremailInfo(param);
        }
        this.saveAutoChnMsg(param);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("COUNT", count += this.autoCampaignDao.updateContentInfo(param));
        resultMap.put(Column.SEND_ID, param.get(Column.SEND_ID));
        resultMap.put(Column.CONTENT_URL, param.get(Column.CONTENT_URL));
        resultMap.put(Column.CONTENT, param.get(Column.CONTENT));
        resultMap.put(Column.REG_ID, param.get(Column.REG_ID));
        resultMap.put(Column.TYPE, param.get(Column.TYPE));
        return resultMap;
    }

    public int saveAutoChnMsg(Map<String, String> param) {
        String sendId = String.valueOf(param.get(Column.SEND_ID));
        String channelType = String.valueOf(param.get(Column.CHANNEL_TYPE));
        String content = String.valueOf(param.get(Column.CONTENT));
        try {
            FileUtil2.makeUrl(this.autoContentPath);
        }
        catch (IOException e1) {
            this.log.error("makeUrl error : {}", (Throwable)e1);
        }
        if (channelType.equals(ChannelType.EMAIL.getCode())) {
            if ("H".equals(param.get(Column.CONTENT_TYPE))) {
                String htmlName = sendId + "_" + System.currentTimeMillis() + ".html";
                String baseContentPath = this.autoContentPath + "/" + htmlName;
                param.put(Column.CONTENT_PATH, baseContentPath);
                try {
                    FileUtil2.writeLocal(baseContentPath, content, false);
                    param.put(Column.CONTENT_URL, this.autoContentUrl + "/" + htmlName);
                }
                catch (Exception e) {
                    this.log.error("auto writeLocal error : {}", (Throwable)e);
                }
            }
        } else if (channelType.equals(ChannelType.SMS.getCode())) {
            String htmlName = sendId + "_" + System.currentTimeMillis() + ".sms";
            String baseContentPath = this.autoContentPath + "/" + htmlName;
            param.put(Column.CONTENT_PATH, baseContentPath);
            try {
                FileUtil2.writeLocal(baseContentPath, content, "utf-8", false);
                param.put(Column.CONTENT_URL, this.autoContentUrl + "/" + htmlName);
            }
            catch (Exception e) {
                this.log.error("auto writeLocal error : {}", (Throwable)e);
            }
        } else if (channelType.equals(ChannelType.PUSH.getCode())) {
            String htmlName = sendId + "_" + System.currentTimeMillis() + ".push";
            String baseContentPath = this.autoContentPath + "/" + htmlName;
            param.put(Column.CONTENT_PATH, baseContentPath);
            try {
                FileUtil2.writeLocal(baseContentPath, content, false);
                param.put(Column.CONTENT_URL, this.autoContentUrl + "/" + htmlName);
            }
            catch (Exception e) {
                this.log.error("auto writeLocal error : {}", (Throwable)e);
            }
        } else if (channelType.equals(ChannelType.KAKAO.getCode())) {
            String htmlName = sendId + "_" + System.currentTimeMillis() + ".kakao";
            String baseContentPath = this.autoContentPath + "/" + htmlName;
            param.put(Column.CONTENT_PATH, baseContentPath);
            try {
                FileUtil2.writeLocal(baseContentPath, content, "utf-8", false);
                param.put(Column.CONTENT_URL, this.autoContentUrl + "/" + htmlName);
            }
            catch (Exception e) {
                this.log.error("auto writeLocal error : {}", (Throwable)e);
            }
        }
        if (StringUtils.validString((String)param.get(Column.USE_YN)).equals("N")) {
            param.put(Column.USE_YN, "N");
        }
        if (StringUtils.validString((String)param.get("ISCOPY")).equals("Y")) {
            param.put(Column.USE_YN, "N");
        }
        return 1;
    }

    public Map<String, String> selectSiteInfo(Map<String, String> param) throws Exception {
        Map<String, String> siteInfo = this.autoCampaignDao.selectSiteInfo(param);
        if (siteInfo.isEmpty()) {
            this.log.error("[ERROR] SiteInfo size zero / SITE_KEY: [{}]", (Object)param.get(Column.SITE_KEY));
            throw new Exception("[ERROR] SiteInfo size zero / SITE_KEY: [" + param.get(Column.SITE_KEY) + "]");
        }
        if (StringUtils.isNull((String)String.valueOf(siteInfo.get(Column.REG_ID))) || StringUtils.isNull((String)String.valueOf(siteInfo.get(Column.SITE_ID)))) {
            this.log.error("[ERROR] Site Key is null Or RegId is null / SITE_KEY: [{}]", (Object)param.get(Column.SITE_KEY));
            throw new Exception("[ERROR] Site Key is null Or RegId is null / SITE_KEY [" + param.get(Column.SITE_KEY) + "]");
        }
        param.put(Column.REG_ID, String.valueOf(siteInfo.get(Column.REG_ID)));
        param.put(Column.SITE_ID, String.valueOf(siteInfo.get(Column.SITE_ID)));
        param.put(Column.DEPT_ID, String.valueOf(siteInfo.get(Column.DEPT_ID)));
        param.put(Column.DB_TYPE, String.valueOf(siteInfo.get(Column.DB_TYPE)));
        if (ChannelType.PUSH.same(param.get(Column.CHANNEL_TYPE))) {
            if (StringUtils.isNull((String)String.valueOf(siteInfo.get(Column.APP_GRP_ID)))) {
                this.log.error("[ERROR] SiteInfo APP_GRP_ID IS NULL / SITE_KEY:[{}] TMA_APP_KEY:[{}]", (Object)param.get(Column.SITE_KEY), (Object)param.get(Column.TMA_APP_KEY));
                throw new Exception("[ERROR] SiteInfo APP_GRP_ID IS NULL / SITE_KEY: [" + param.get(Column.SITE_KEY) + "]");
            }
            param.put(Column.APP_GRP_ID, String.valueOf(siteInfo.get(Column.APP_GRP_ID)));
        }
        return param;
    }

    public int insertAutoMsgQuery(Map<String, String> param) {
        int result = 0;
        String targetId = this.autoCampaignDao.selectTargetId(String.valueOf(param.get(Column.SEND_ID)));
        if (targetId == null) {
            result += this.autoCampaignDao.insertTargetInfo(param);
            result += this.autoCampaignDao.updateSendInfoByTargetId(param);
        } else {
            param.put(Column.TARGET_ID, targetId);
        }
        if (param.containsKey("ENCRYPT_YN")) {
            param.put("CUST_ENCRYPT_YN", param.get("ENCRYPT_YN"));
        }
        param.put("ENCRYPT_YN", this.encryptYn);
        return result += this.insertTargetLinkQueryInfo(param);
    }

    public int insertTargetLinkQueryInfo(Map<String, String> param) {
        param.put(Column.DB_ID, "-1");
        String sendId = String.valueOf(param.get(Column.SEND_ID));
        String currentTime = "SYSDATE";
        if (param.get(Column.DB_TYPE).equals("Oracle")) {
            currentTime = "SYSDATE";
        } else if (param.get(Column.DB_TYPE).equals("MySQL") || param.get(Column.DB_TYPE).equals("MariaDB")) {
            currentTime = "NOW()";
        }
        int result = 0;
        for (int i = 0; i < 3; ++i) {
            StringBuffer query = new StringBuffer();
            switch (i) {
                case 0: {
                    query.append(" SELECT ID AS TMS_M_ID, \n").append("        NAME AS TMS_M_NAME, \n").append("        EMAIL AS TMS_M_EMAIL, \n").append("        PHONE AS TMS_M_PHONE, \n").append("        TOKEN AS TMS_M_TOKEN, \n").append("        REQ_UID AS TMA_REQ_UID, \n").append("        ETC AS ETC, \n").append("        SEQ_ID AS SEQ_ID \n").append(" FROM   TMS_TMA_USER_LIST \n").append(" WHERE  TRAN_YN = 'N' \n").append(" AND    SEND_ID = ").append(" '" + sendId + "'").append(" ");
                    param.put(Column.QUERY_TYPE, "10");
                    break;
                }
                case 1: {
                    query.append(" SELECT CONTENT AS CONTENT \n").append(" FROM   TMS_TMA_USER_LIST \n").append(" WHERE  SEQ_ID = '@{SEQ_ID}' ");
                    param.put(Column.QUERY_TYPE, "20");
                    break;
                }
                case 2: {
                    query.append(" UPDATE TMS_TMA_USER_LIST \n").append(" SET    TRAN_YN = 'Y', \n").append("     \t  UPT_DATE= ").append(currentTime).append(" \n").append(" WHERE  SEQ_ID = '@{SEQ_ID}' ");
                    param.put(Column.QUERY_TYPE, "40");
                }
            }
            param.put(Column.QUERY, query.toString());
            result += this.autoCampaignDao.insertTargetLinkInfo(param);
            result += this.autoCampaignDao.insertTargetQueryInfo(param);
        }
        return result;
    }

    public int checkSendId(Map<String, String> params) {
        return this.autoCampaignDao.selectSendIdCnt(params);
    }
}

