/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.ajp;

import org.apache.catalina.connector.Connector;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ContainerConfig {
    @Value(value="${server.ajp.protocol}")
    String ajpProtocol;
    @Value(value="${server.ajp.port}")
    int ajpPort;
    @Value(value="${server.ajp.enabled}")
    boolean tomcatAjpEnabled;

    @Bean
    public EmbeddedServletContainerFactory servletContainer() {
        TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory();
        Connector ajpConnector = new Connector(this.ajpProtocol);
        ajpConnector.setProtocol(this.ajpProtocol);
        ajpConnector.setPort(this.ajpPort);
        tomcat.addAdditionalTomcatConnectors(new Connector[]{ajpConnector});
        return tomcat;
    }
}

