/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil
extends StringUtils {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    private static DecimalFormat numberFormatter = new DecimalFormat();

    public static boolean isValidate(String text) {
        boolean result = false;
        result = text != null && !text.trim().isEmpty();
        return result;
    }

    public static String[] splitToList(String strData, String delimiter) {
        if (!StringUtil.isValidate(strData)) {
            return null;
        }
        if (delimiter.equalsIgnoreCase("|")) {
            delimiter = "\\|";
        }
        String[] list = strData.split(delimiter);
        return list;
    }

    public static ArrayList<String> splitToList(String strData, String delimiter, String excludeString) {
        if (!StringUtil.isValidate(strData)) {
            return null;
        }
        if (delimiter.equalsIgnoreCase("|")) {
            delimiter = "\\|";
        }
        String[] arrSplited = strData.split(delimiter);
        ArrayList<String> arrSplitedData = new ArrayList<String>();
        for (int i = 0; i < arrSplited.length; ++i) {
            String token = arrSplited[i].trim();
            if (!StringUtil.isValidate(token) || token.equalsIgnoreCase(excludeString.trim())) continue;
            arrSplitedData.add(token);
        }
        return arrSplitedData;
    }

    public static LinkedHashMap<String, Integer> splitToMap(String strData, String delimiter) {
        if (!StringUtil.isValidate(strData)) {
            return null;
        }
        StringTokenizer strToken = new StringTokenizer(strData, delimiter);
        LinkedHashMap<String, Integer> mapSplitList = new LinkedHashMap<String, Integer>();
        int i = 0;
        while (strToken.hasMoreTokens()) {
            mapSplitList.put(strToken.nextToken().trim(), i);
            ++i;
        }
        return mapSplitList;
    }

    public static boolean hasKey(Map<String, Object> map, String keyName) {
        try {
            if (!map.containsKey(keyName)) {
                return false;
            }
            if (map.get(keyName) == null) {
                return false;
            }
            return !String.valueOf(map.get(keyName)).trim().isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] compress(String data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());
        GZIPOutputStream gzip = new GZIPOutputStream(bos);
        gzip.write(data.getBytes());
        gzip.close();
        byte[] compressed = bos.toByteArray();
        bos.close();
        return compressed;
    }

    public static String decompress(byte[] compressed) throws IOException {
        String line;
        ByteArrayInputStream bis = new ByteArrayInputStream(compressed);
        GZIPInputStream gis = new GZIPInputStream(bis);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        gis.close();
        bis.close();
        return sb.toString();
    }

    public static Map<String, String> convertStringMap(Map<String, Object> originalMap) throws Exception {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (String strKey : originalMap.keySet()) {
            newMap.put(strKey, String.valueOf(originalMap.get(strKey)));
        }
        return newMap;
    }

    public static Map<String, String> convertMap(Map<String, String> originalMap) throws Exception {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (String strKey : originalMap.keySet()) {
            newMap.put(strKey, String.valueOf(originalMap.get(strKey)));
        }
        return newMap;
    }

    public static final String getDomain(String str) {
        if (str == null) {
            return "";
        }
        int index = str.indexOf(64);
        if (index < 0) {
            return "";
        }
        return str.substring(index + 1);
    }

    public static void main(String[] args) {
        String text = "C3-2451:1534819026484";
        String[] split = text.split(":");
        System.out.println("split=" + split[split.length - 1]);
    }
}

