/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.util;

import com.humuson.tms.trans.repository.model.TmsTargetLinkQueryInfo;
import com.humuson.tms.trans.repository.model.TmsTestInfo;
import com.humuson.tms.trans.util.BeanUtilRegister;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class ObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(ObjectUtil.class);

    public static <T> void objectMergeNullIgnore(T t, Object ... objects) throws Exception {
        if (ObjectUtils.isEmpty((Object[])objects)) {
            return;
        }
        ObjectUtil.objectMerge(t, objects);
    }

    public static <T> void objectMerge(T t, Object ... objects) throws Exception {
        BeanUtilRegister.Instance.name();
        for (Object o : objects) {
            try {
                BeanUtils.copyProperties(t, (Object)o);
            }
            catch (IllegalAccessException e) {
                log.error("object copy dest[{}], org[{}] error ", new Object[]{t.getClass().getName(), o.getClass().getName(), e});
                throw e;
            }
            catch (InvocationTargetException e) {
                log.error("object copy dest[{}], org[{}] error ", new Object[]{t.getClass().getName(), o.getClass().getName(), e});
                throw e;
            }
        }
    }

    private static <T> T mapToBean(Class<T> resultType, Map<String, Object> map) {
        try {
            T t = resultType.newInstance();
            BeanUtils.populate(t, map);
            return t;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("map[{}] to bean[{}] change error. next continue..", map, (Object)resultType.getName());
            return null;
        }
        catch (InstantiationException e) {
            log.error("create new Instance error. \nmap[{}] to bean[{}] next continue..", map, (Object)resultType.getName());
            log.error("print stack trace", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        TmsTestInfo tmsTestInfo = new TmsTestInfo();
        tmsTestInfo.setCAMP_ID("Copyed");
        tmsTestInfo.setCHANNEL_ID(0);
        tmsTestInfo.setTEST_ID(10);
        tmsTestInfo.setSEND_ID(100);
        tmsTestInfo.setREG_ID("orgined");
        TmsTargetLinkQueryInfo targetListQueryInfo = new TmsTargetLinkQueryInfo();
        targetListQueryInfo.setREG_ID("first");
        targetListQueryInfo.setQUERY_ID(200);
        targetListQueryInfo.setDB_ID(0);
        targetListQueryInfo.setQUERY_TYPE("10");
        targetListQueryInfo.setQUERY("SELECT * FROM TABLE WHERE AAA=AAA");
        targetListQueryInfo.setREG_ID("netwel2");
        targetListQueryInfo.setREG_DATE(new Timestamp(System.currentTimeMillis()));
        TmsTargetLinkQueryInfo targetListQueryInfo1 = new TmsTargetLinkQueryInfo();
        targetListQueryInfo1.setREG_ID("second");
        targetListQueryInfo1.setQUERY_ID(200);
        targetListQueryInfo1.setDB_ID(1);
        targetListQueryInfo1.setQUERY_TYPE("10");
        targetListQueryInfo1.setQUERY("SELECT * FROM TABLE WHERE AAA=AAA");
        targetListQueryInfo1.setREG_ID("netwel2");
        targetListQueryInfo1.setREG_DATE(new Timestamp(System.currentTimeMillis()));
        TmsTargetLinkQueryInfo targetListQueryInfo2 = new TmsTargetLinkQueryInfo();
        targetListQueryInfo2.setREG_ID("second");
        targetListQueryInfo2.setQUERY_ID(200);
        targetListQueryInfo2.setQUERY_TYPE("10");
        targetListQueryInfo2.setQUERY("SELECT * FROM TABLE WHERE AAA=AAA");
        targetListQueryInfo2.setREG_ID("netwel2");
        targetListQueryInfo2.setREG_DATE(new Timestamp(System.currentTimeMillis()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TRIGGER_METHOD", "O8");
        map.put("REG_ID", "last");
        try {
            ObjectUtil.objectMerge(targetListQueryInfo, targetListQueryInfo1, targetListQueryInfo2, map);
            System.out.println(targetListQueryInfo);
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
        }
    }
}

