/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.stereotype.Component;

@Component
public class JobParameterUtil {
    private static final Logger log = LoggerFactory.getLogger(JobParameterUtil.class);

    public JobParameters getJobParametersFromMap(Map<String, Object> jobDataMap) {
        JobParametersBuilder builder = new JobParametersBuilder();
        for (Map.Entry<String, Object> entry : jobDataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                builder.addString(key, (String)value);
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                builder.addDouble(key, Double.valueOf(((Number)value).doubleValue()));
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                builder.addLong(key, Long.valueOf(((Number)value).longValue()));
                continue;
            }
            if (value instanceof Date) {
                builder.addDate(key, (Date)value);
                continue;
            }
            log.debug("JobDataMap contains values which are not job parameters (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        return builder.toJobParameters();
    }

    public HashMap<String, Object> getMapFromJobParameters(JobParameters jobParams) {
        HashMap<String, Object> jobDataMap = new HashMap<String, Object>();
        for (Map.Entry entry : jobParams.getParameters().entrySet()) {
            String key = (String)entry.getKey();
            Object value = ((JobParameter)entry.getValue()).getValue();
            if (value instanceof String) {
                jobDataMap.put(key, (String)value);
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                jobDataMap.put(key, (Number)value);
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                jobDataMap.put(key, (Number)value);
                continue;
            }
            if (value instanceof Date) {
                jobDataMap.put(key, (Date)value);
                continue;
            }
            log.debug("JobDataMap contains values which are not object (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        return jobDataMap;
    }

    public HashMap<String, Object> getMapFromStepContext(ExecutionContext stepContext) {
        HashMap<String, Object> jobDataMap = new HashMap<String, Object>();
        for (Map.Entry entry : stepContext.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                jobDataMap.put(key, (String)value);
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                jobDataMap.put(key, (Number)value);
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                jobDataMap.put(key, (Number)value);
                continue;
            }
            if (value instanceof Date) {
                jobDataMap.put(key, (Date)value);
                continue;
            }
            log.debug("JobDataMap contains values which are not object (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        return jobDataMap;
    }
}

