/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.upload;

import com.humuson.tms.trans.upload.UploadFilterInfoListener;
import com.humuson.tms.trans.upload.UploadFilterInfoService;
import org.mybatis.spring.batch.MyBatisCursorItemReader;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UploadFilterInfoServiceImpl
implements UploadFilterInfoService {
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private UploadFilterInfoListener listener;
    @Autowired
    @Qualifier(value="uploadHardReader")
    private MyBatisCursorItemReader uploadToRedisFilterHardReaderCustom;
    @Autowired
    @Qualifier(value="uploadHardWriter")
    private ItemWriter uploadToRedisFilterHardWriterCustom;
    @Autowired
    @Qualifier(value="uploadSiteReader")
    private MyBatisCursorItemReader UploadToRedisFilterSiteReaderCustom;
    @Autowired
    @Qualifier(value="uploadSiteWriter")
    private ItemWriter UploadToRedisFilterSiteWriterCustom;
    @Autowired
    @Qualifier(value="uploadPushBMKTReader")
    private MyBatisCursorItemReader uploadToRedisFilterPushBMKTReaderCustom;
    @Autowired
    @Qualifier(value="uploadPushBMKTWriter")
    private ItemWriter uploadToRedisFilterPushBMKTWriterCustom;
    @Value(value="${tms.upload-info.filter.chunk-size}")
    private int chunkSize;

    @Override
    public Job job() {
        return ((SimpleJobBuilder)((JobBuilder)this.jobBuilderFactory.get("resultKaJobN").incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(this.step("UploadSiteUser")).next(this.step("UploadHardbounce")).next(this.step("UploadPushBMKT")).listener((JobExecutionListener)this.listener)).build();
    }

    @Override
    @StepScope
    public Step step(String stepKey) {
        if ("UploadHardbounce".equals(stepKey)) {
            return this.stepBuilderFactory.get(stepKey).chunk(this.chunkSize).reader((ItemReader)this.uploadToRedisFilterHardReaderCustom).writer(this.uploadToRedisFilterHardWriterCustom).listener((Object)this.listener).build();
        }
        if ("UploadSiteUser".equals(stepKey)) {
            return this.stepBuilderFactory.get(stepKey).chunk(this.chunkSize).reader((ItemReader)this.UploadToRedisFilterSiteReaderCustom).writer(this.UploadToRedisFilterSiteWriterCustom).listener((Object)this.listener).build();
        }
        if ("UploadPushBMKT".equals(stepKey)) {
            return this.stepBuilderFactory.get(stepKey).chunk(this.chunkSize).reader((ItemReader)this.uploadToRedisFilterPushBMKTReaderCustom).writer(this.uploadToRedisFilterPushBMKTWriterCustom).listener((Object)this.listener).build();
        }
        return null;
    }
}

