/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.upload;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class UploadFilterInfoListener
extends JobExecutionListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(UploadFilterInfoListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterJob(JobExecution jobExecution) {
        if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
            // empty if block
        }
        try {
            long startTime = jobExecution.getJobParameters().getLong("time");
            log.info("[UploadToRedisFilter_END] job id :{}, state :{}, Time taken {} ms", new Object[]{jobExecution.getId(), jobExecution.getStatus(), System.currentTimeMillis() - startTime});
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
        }
        log.info("------------------------------------------------------------------");
    }

    public void beforeJob(JobExecution jobExecution) {
        log.info("------------------------------------------------------------------");
        log.info("[UploadToRedisFilter_START] job id :{} ", (Object)jobExecution.getId());
    }
}

