/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.target;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.module.TmsBatchTargetInfoFactory;
import com.humuson.tms.trans.module.batch.TmsBatchDbTargetExecutor;
import com.humuson.tms.trans.module.batch.TmsBatchFileTargetExecutor;
import com.humuson.tms.trans.module.batch.TmsBatchTargetExecutor;
import com.humuson.tms.trans.module.batch.TmsBatchTargetInfo;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.dao.TargetInfoDao;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@EnableScheduling
public class TmsBatchTargetScheduler {
    private static final Logger log = LoggerFactory.getLogger(TmsBatchTargetScheduler.class);
    private static final String BATCH_LOCK = "BATCH_LOCK";
    final SendInfoDao sendInfoDao;
    final TargetInfoDao targetInfoDao;
    final TmsBatchTargetInfoFactory batchTargetInfoFactory;
    final DefaultDatabaseConfig defaultDatabaseConfig;
    boolean isOracle;

    @PostConstruct
    public void init() {
        this.isOracle = DBType.ORACLE == this.defaultDatabaseConfig.getDbType();
    }

    @DistributeLock(value="BATCH_LOCK")
    @ProcessFeasible(name=Constants.JobName.O_MASS)
    @Scheduled(fixedDelay=3000L)
    public void batchTargetSchedule() {
        List<TmsSendInfo> sendInfos = this.searchBatchEventJobStatus20();
        if (ObjectUtils.isEmpty(sendInfos)) {
            return;
        }
        if (log.isDebugEnabled()) {
            for (TmsSendInfo sendInfo : sendInfos) {
                log.debug("batch target send info[{}] ", (Object)sendInfo);
            }
        }
        this.batchTargetEventListener(sendInfos);
    }

    private List<TmsSendInfo> searchBatchEventJobStatus20() {
        return this.sendInfoDao.selectSendInfosOfStatus("20");
    }

    public void batchTargetEventListener(List<TmsSendInfo> tmsSendInfos) {
        for (TmsSendInfo tmsSendInfo : tmsSendInfos) {
            try {
                TmsBatchTargetInfo tmsBatchTargetInfo = this.batchTargetInfoFactory.createBatchTargetInfo(tmsSendInfo);
                TmsBatchTargetExecutor executor = Constants.TargetType.FILE.name().equalsIgnoreCase(tmsSendInfo.getTARGET_TYPE()) ? (TmsBatchTargetExecutor)ClassDispatcher.getApplicationContext().getBean(TmsBatchFileTargetExecutor.class) : (TmsBatchTargetExecutor)ClassDispatcher.getApplicationContext().getBean(TmsBatchDbTargetExecutor.class);
                executor.createJobParameters(tmsSendInfo);
                executor.execute(tmsBatchTargetInfo);
            }
            catch (Exception e) {
                log.error("DS0153|sendInfo.send_id[{}] push data move targeting error send_info[{}]", new Object[]{tmsSendInfo.getSEND_ID(), tmsSendInfo, e});
                this.updateSendInfoJobStatus(tmsSendInfo.getSEND_ID(), "31");
            }
        }
    }

    private void updateSendInfoJobStatus(long sendId, String jobStatus) {
        this.sendInfoDao.updateSendInfoJobStatus(sendId, jobStatus);
    }

    public TmsBatchTargetScheduler(SendInfoDao sendInfoDao, TargetInfoDao targetInfoDao, TmsBatchTargetInfoFactory batchTargetInfoFactory, DefaultDatabaseConfig defaultDatabaseConfig) {
        this.sendInfoDao = sendInfoDao;
        this.targetInfoDao = targetInfoDao;
        this.batchTargetInfoFactory = batchTargetInfoFactory;
        this.defaultDatabaseConfig = defaultDatabaseConfig;
    }
}

