/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.target;

import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.trans.module.test.BasicTestSender;
import com.humuson.tms.trans.module.test.FileTestSender;
import com.humuson.tms.trans.module.test.TestSender;
import com.humuson.tms.trans.repository.dao.TestSendInfoDao;
import com.humuson.tms.trans.repository.model.TmsTargetInfo;
import com.humuson.tms.trans.repository.model.TmsTestInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.schedule.use", name={"O8"}, havingValue="true", matchIfMissing=true)
public class TestSendScheduler {
    private static final Logger log = LoggerFactory.getLogger(TestSendScheduler.class);
    private final TestSendInfoDao testSendInfoDao;
    private static final String O8 = "O8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DistributeLock(value="O8")
    @Scheduled(fixedDelayString="${tms.schedule.once.test:3000}")
    public void o8TestSendSchedule() {
        List<TmsTestInfo> tmsTestInfos = null;
        try {
            tmsTestInfos = this.testSendInfoDao.selectTestInfo("10");
            if (log.isDebugEnabled()) {
                log.debug("test scheduler selected count[{}] ", (Object)tmsTestInfos.size());
            }
            for (TmsTestInfo testInfo : tmsTestInfos) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("starting tms test sender info[{}]", (Object)testInfo);
                    }
                    if (testInfo.isAB_YN()) {
                        this.updateRealTargetId(testInfo);
                    }
                    TestSender testSender = this.getTestSender(testInfo.getTARGET_TYPE().trim());
                    testSender.setTmsTestInfo(testInfo);
                    if (this.failedAssemblyTestQuery(testSender)) continue;
                    testSender.registTestScheduler();
                    if (!log.isInfoEnabled()) continue;
                    log.info("end tms test sender test_id[{}]", (Object)testInfo.getTEST_ID());
                }
                catch (Exception e) {
                    log.error("DS0151|test send info[{}] error. continue..", (Object)testInfo, (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("DS0152|DATA-SCHEDULER has Exception. {} ", (Object)e.getMessage());
        }
        finally {
            tmsTestInfos.clear();
            tmsTestInfos = null;
        }
    }

    private void updateRealTargetId(TmsTestInfo testInfo) {
        TmsTargetInfo tmsTargetInfo = this.testSendInfoDao.selectABMainTargetInfo(testInfo.getSEND_ADD_ID());
        testInfo.setTARGET_ID(tmsTargetInfo.getTARGET_ID());
        testInfo.setTARGET_TYPE(tmsTargetInfo.getTARGET_TYPE());
    }

    private TestSender getTestSender(String targetType) {
        if (Constants.TargetType.FILE.name().equals(targetType)) {
            return (TestSender)ClassDispatcher.getApplicationContext().getBean(FileTestSender.class);
        }
        return (TestSender)ClassDispatcher.getApplicationContext().getBean(BasicTestSender.class);
    }

    private boolean failedAssemblyTestQuery(TestSender testSender) {
        return !testSender.assembleTestQuery();
    }

    public TestSendScheduler(TestSendInfoDao testSendInfoDao) {
        this.testSendInfoDao = testSendInfoDao;
    }
}

