/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.target;

import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.event.TypeTargetEvent;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public abstract class SendTargetEventer<T extends TmsSendInfo> {
    private static final Logger log = LoggerFactory.getLogger(SendTargetEventer.class);
    protected final ApplicationEventPublisher publisher;
    protected final SendInfoDao sendInfoDao;

    public void createEventer(List<T> targetInfos, Constants.TriggerMethod targetMethod) {
        if (ObjectUtils.isEmpty(targetInfos)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] target event create size[{}]", (Object)targetMethod, (Object)targetInfos.size());
        }
        ArrayList<TmsSendInfo> tmsSendInfosForEvent = new ArrayList<TmsSendInfo>();
        for (TmsSendInfo sendInfo : targetInfos) {
            try {
                int updateCount;
                if (log.isInfoEnabled()) {
                    log.info("proceed send target event target method[{}] send_id[{}] send_info[{}]", new Object[]{targetMethod.name(), sendInfo.getSEND_ID(), sendInfo});
                }
                if ((updateCount = this.sendInfoDao.updateSendInfoJobStatus(sendInfo.getSEND_ID(), "15")) != 1) {
                    log.warn("send id[{}] job_status(15) update count is not oneso don't create event. skip.. , count[{}]", (Object)sendInfo.getSEND_ID(), (Object)updateCount);
                    continue;
                }
                tmsSendInfosForEvent.add(sendInfo);
            }
            catch (Exception e) {
                log.error("DS0150|send id[{}] job_status update error. skip..", (Object)sendInfo.getSEND_ID(), (Object)e);
            }
        }
        if (ObjectUtils.isEmpty(tmsSendInfosForEvent)) {
            return;
        }
        this.callEvent(targetMethod, tmsSendInfosForEvent);
    }

    protected synchronized void callEvent(final Constants.TriggerMethod triggerMethod, final List<T> targetList) {
        this.publisher.publishEvent((Object)new TypeTargetEvent<List<T>>(){

            @Override
            public List<T> getTargetEvent() {
                return targetList;
            }

            @Override
            public Constants.TriggerMethod getType() {
                return triggerMethod;
            }
        });
    }

    public SendTargetEventer(ApplicationEventPublisher publisher, SendInfoDao sendInfoDao) {
        this.publisher = publisher;
        this.sendInfoDao = sendInfoDao;
    }
}

