/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.target;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.module.TmsBatchTargetInfoFactory;
import com.humuson.tms.trans.module.batch.TmsBatchDbTargetExecutor;
import com.humuson.tms.trans.repository.dao.ResendInfoDao;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class ResendTargetScheduler {
    private static final Logger log = LoggerFactory.getLogger(ResendTargetScheduler.class);
    private static final String O7_T = "O7_T";
    private static final String RESEND_TRIGGER_METHOD = "O7";
    final TmsBatchTargetInfoFactory batchTargetInfoFactory;
    final TmsBatchDbTargetExecutor executor;
    final ResendInfoDao resendInfoDao;

    @DistributeLock(value="O7_T")
    @ProcessFeasible(name=Constants.JobName.O_TYPE)
    @Scheduled(fixedDelayString="${tms.schedule.resend:2000}")
    public void resendTargetingScheduler() {
        try {
            List<TmsSchdInfo> tmsSchdInfos = this.resendInfoDao.selectSchdInfosOfTrigger(RESEND_TRIGGER_METHOD, "10");
            for (TmsSchdInfo tmsSchdInfo : tmsSchdInfos) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ResendTargetScheduler(TmsBatchTargetInfoFactory batchTargetInfoFactory, TmsBatchDbTargetExecutor executor, ResendInfoDao resendInfoDao) {
        this.batchTargetInfoFactory = batchTargetInfoFactory;
        this.executor = executor;
        this.resendInfoDao = resendInfoDao;
    }
}

