/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.target;

import com.humuson.tms.adaptor.jdbc.mybatis.DynamicMapSqlMapper;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.repository.dao.ResendInfoDao;
import com.humuson.tms.trans.repository.model.TmsResendInfo;
import com.humuson.tms.trans.repository.model.TmsResendTarget;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSchdTarget;
import com.humuson.tms.trans.util.ObjectUtil;
import com.humuson.tms.util.date.DateUtil;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
@Transactional
@EnableScheduling
public class ResendScheduler {
    private static final Logger log = LoggerFactory.getLogger(ResendScheduler.class);
    private static final String O7 = "O7";
    private final ResendInfoDao resendInfoDao;
    private final DynamicMapSqlMapper sqlMapper;

    @DistributeLock(value="O7")
    @ProcessFeasible(name=Constants.JobName.O_TYPE)
    @Scheduled(fixedDelayString="${tms.schedule.resend:3000}")
    public void o7ResendScheduler() {
        try {
            List<TmsResendInfo> resendInfos = this.resendInfoDao.selectResendInfo("10");
            for (TmsResendInfo resendInfo : resendInfos) {
                try {
                    this.resendInfoDao.updateResendInfoJobStatus(resendInfo.getRESEND_ID(), "20");
                    List<TmsResendTarget> resendTargets = this.resendInfoDao.selectResendTarget(resendInfo.getRESEND_ID());
                    long schdId = this.makeSchdInfo(resendInfo, resendTargets.size());
                    this.finishResendInfo(resendInfo, schdId);
                }
                catch (NotExistSchdInfoException e1) {
                    log.error("DS0149|failed search schd_info.schd_id[{}] in resend_info.so 41 update. resend_info[{}]", new Object[]{resendInfo.getSCHD_ID(), resendInfo, e1});
                    this.resendInfoDao.updateResendInfoJobStatus(resendInfo.getRESEND_ID(), "41");
                }
                catch (Exception e) {
                    log.error("resend info targeting error. so 41 update. resend_info[{}]", (Object)resendInfo, (Object)e);
                    this.resendInfoDao.updateResendInfoJobStatus(resendInfo.getRESEND_ID(), "41");
                }
            }
        }
        catch (SQLException e) {
            log.error("DS0148|resend service error. so retry..", (Throwable)e);
        }
    }

    @Transactional
    protected void finishResendInfo(TmsResendInfo resendInfo, long schdId) {
        try {
            this.resendInfoDao.updateSchdInfoJobStatus(schdId, "10");
            this.resendInfoDao.updateResendInfoJobStatus(resendInfo.getRESEND_ID(), "30");
        }
        catch (Exception e) {
            log.error("DS0147|resend[{}]/schd_info[{}] jobstatus[30] update error. so next..", new Object[]{resendInfo.getRESEND_ID(), schdId, e});
        }
    }

    @Transactional
    protected long makeSchdInfo(TmsResendInfo resendInfo, int resendTargetSize) throws Exception {
        TmsSchdInfo tmsSchdInfo = new TmsSchdInfo();
        TmsSchdInfo tmsSchdInfoOrg = this.resendInfoDao.selectSchdInfo(resendInfo.getSCHD_ID());
        if (ObjectUtils.isEmpty((Object)tmsSchdInfoOrg)) {
            throw new NotExistSchdInfoException("SCHD_INFO.SCHD_ID=" + resendInfo.getSCHD_ID());
        }
        ObjectUtil.objectMerge(tmsSchdInfo, tmsSchdInfoOrg);
        this.setAddField(tmsSchdInfo, resendInfo, resendTargetSize);
        this.resendInfoDao.insertTmsSchdInfo(tmsSchdInfo);
        TmsSchdTarget schdTarget = new TmsSchdTarget();
        ObjectUtil.objectMerge(schdTarget, this.resendInfoDao.selectSchdTarget(resendInfo.getSCHD_ID()));
        schdTarget.setSCHD_ID(tmsSchdInfo.getSCHD_ID());
        schdTarget.setTARGET_DB_ID(-1);
        schdTarget.setTRANSFER_YN("N");
        schdTarget.setENCRYPT_YN("N");
        if (this.isPushChannel(tmsSchdInfoOrg.getCHANNEL_TYPE())) {
            schdTarget.setTARGET_QUERY_S(this.sqlMapping(this.sqlMapper.boundOriginalSql("getResendPushTargetQuery"), resendInfo, tmsSchdInfo.getWORKDAY()));
        } else {
            schdTarget.setTARGET_QUERY_S(this.sqlMapping(this.sqlMapper.boundOriginalSql("getResendTargetQuery"), resendInfo, tmsSchdInfo.getWORKDAY()));
        }
        schdTarget.setCT_TARGET_TYPE("DB");
        schdTarget.setREG_DATE(null);
        this.resendInfoDao.insertTmsSchdTarget(schdTarget);
        return tmsSchdInfo.getSCHD_ID();
    }

    private boolean isPushChannel(String channelType) {
        return Constants.ChannelType.PU.name().equalsIgnoreCase(channelType.trim());
    }

    private String sqlMapping(String sql, TmsResendInfo resendInfo, String workday) {
        resendInfo.setWORKDAY("'" + workday + "'");
        return this.sqlMapper.dynamicBoundSql(sql, (Object)resendInfo, "#{");
    }

    private void setAddField(TmsSchdInfo tmsSchdInfo, TmsResendInfo resendInfo, int targetCount) {
        tmsSchdInfo.setSCHD_ID(0L);
        tmsSchdInfo.setWORKDAY(DateUtil.getWorkday());
        tmsSchdInfo.setJOB_STATUS("00");
        tmsSchdInfo.setDEL_YN("N");
        tmsSchdInfo.setWORKING_YN("N");
        tmsSchdInfo.setTRIGGER_METHOD(Constants.TriggerMethod.O7.name());
        tmsSchdInfo.setINIT_TARGET(targetCount);
        tmsSchdInfo.setREG_ID(resendInfo.getREG_ID());
        tmsSchdInfo.setRESEND_ID(resendInfo.getRESEND_ID());
        tmsSchdInfo.setTRACKING_CLOSE(DateUtil.addDate((String)"yyyy-MM-dd", (int)1));
        tmsSchdInfo.setGRP_ID("" + System.currentTimeMillis());
    }

    public ResendScheduler(ResendInfoDao resendInfoDao, DynamicMapSqlMapper sqlMapper) {
        this.resendInfoDao = resendInfoDao;
        this.sqlMapper = sqlMapper;
    }

    class NotExistSchdInfoException
    extends Exception {
        private static final long serialVersionUID = 1L;

        NotExistSchdInfoException(String msg) {
            super(msg);
        }
    }
}

