/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.target;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.schedule.target.OnceTargetEventer;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class OnceTargetScheduler
extends OnceTargetEventer {
    public static final String O1 = "O1";
    public static final String O9 = "O9";

    public OnceTargetScheduler(ApplicationEventPublisher publisher, SendInfoDao sendInfoDao) {
        super(publisher, sendInfoDao);
    }

    @DistributeLock(value="O1")
    @ProcessFeasible(name=Constants.JobName.O_TYPE, min=1)
    @Scheduled(fixedDelay=3000L)
    public void o1TargetSchedule() {
        this.searchOnceEvent(Constants.TriggerMethod.O1);
    }

    @DistributeLock(value="O9")
    @ProcessFeasible(name=Constants.JobName.O_TYPE, min=1)
    @Scheduled(fixedDelay=3000L)
    public void o9TargetSchedule() {
        this.searchOnceEvent(Constants.TriggerMethod.O9);
    }
}

