/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.target;

import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.trans.schedule.target.SendTargetEventer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public abstract class OnceTargetEventer
extends SendTargetEventer<TmsSendInfo> {
    private static final Logger log = LoggerFactory.getLogger(OnceTargetEventer.class);

    public OnceTargetEventer(ApplicationEventPublisher publisher, SendInfoDao sendInfoDao) {
        super(publisher, sendInfoDao);
    }

    public void searchOnceEvent(Constants.TriggerMethod triggerMethod) {
        try {
            List<TmsSendInfo> tmsSendInfos = this.sendInfoDao.selectOnceTarget(triggerMethod.name());
            if (log.isDebugEnabled()) {
                log.debug("[O1] selectOnceTarget result size={}", (Object)tmsSendInfos.size());
            }
            this.createEventer(tmsSendInfos, triggerMethod);
        }
        catch (Exception e) {
            log.error("DS0146|once target[{}] select error.", (Object)triggerMethod.name(), (Object)e);
        }
    }
}

