/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.target;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.module.TmsBatchTargetInfoFactory;
import com.humuson.tms.trans.module.batch.TmsBatchDbTargetExecutor;
import com.humuson.tms.trans.module.batch.TmsBatchTargetInfo;
import com.humuson.tms.trans.repository.dao.SchdInfoDao;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class DelayTargetScheduler {
    private static final Logger log = LoggerFactory.getLogger(DelayTargetScheduler.class);
    private static final String DELAY_TARGET = "DELAY_TARGET";
    private final TmsBatchTargetInfoFactory tmsBatchTargetInfoFactory;
    private final TmsBatchDbTargetExecutor tmsBatchTargetExecutor;
    private final SchdInfoDao schdInfoDao;

    @DistributeLock(value="DELAY_TARGET")
    @ProcessFeasible(name=Constants.JobName.O_TYPE, min=10)
    @Scheduled(fixedDelayString="${tms.schedule.resend:10000}")
    public void executeTaragetingScheduler() {
        List<TmsSchdInfo> tmsSchdInfos = this.schdInfoDao.selectSchdInfosOfDivide();
        for (TmsSchdInfo schdInfo : tmsSchdInfos) {
            try {
                TmsBatchTargetInfo tmsBatchTargetInfo = this.tmsBatchTargetInfoFactory.createBatchTargetInfo(schdInfo, this.getTargetQuery(schdInfo));
                tmsBatchTargetInfo.setMOVE(false);
                tmsBatchTargetInfo.setDELAY(true);
                tmsBatchTargetInfo.setSCHD_ID(schdInfo.getSCHD_ID());
                tmsBatchTargetInfo.setENCRYPT(false);
                this.tmsBatchTargetExecutor.execute(tmsBatchTargetInfo);
            }
            catch (Exception e) {
                log.error("push divide tageting error. so update jobstatus=41. schd_info={}", (Object)schdInfo, (Object)e);
                this.schdInfoDao.updateSchdInfoJobStatus(schdInfo.getSCHD_ID(), "41");
            }
        }
    }

    private String getTargetQuery(final TmsSchdInfo schdInfo) {
        return ((StringBuilder)new SQL(){
            {
                this.SELECT("TARGET_TEMP_ID, GRP_SEQ       , WORKDAY       , SEND_ID       , TARGET_ID     , TARGET_SEQ    , TMS_M_ID      , TMS_M_NAME    , TMS_M_EMAIL   , TMS_M_PHONE   , TMS_M_TOKEN   , DEVICE_ID     , TARGET_FLAG   , DATA01        , DATA02        , DATA03        , ETC AS TMS_ETC, REG_DATE      , ERR_CODE      , ERR_MSG       , SCHD_ID         ");
                this.FROM(" TMS_TARGET_TEMP");
                this.WHERE(" SCHD_ID =" + schdInfo.getSCHD_ID());
                this.WHERE(" SEND_ID =" + schdInfo.getSEND_ID());
            }
        }.usingAppender((Appendable)new StringBuilder())).toString();
    }

    public DelayTargetScheduler(TmsBatchTargetInfoFactory tmsBatchTargetInfoFactory, TmsBatchDbTargetExecutor tmsBatchTargetExecutor, SchdInfoDao schdInfoDao) {
        this.tmsBatchTargetInfoFactory = tmsBatchTargetInfoFactory;
        this.tmsBatchTargetExecutor = tmsBatchTargetExecutor;
        this.schdInfoDao = schdInfoDao;
    }
}

