/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.target;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.schedule.target.CycleTargetEventer;
import com.humuson.tms.util.Cal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class CycleTargetScheduler
extends CycleTargetEventer {
    private static final Logger log = LoggerFactory.getLogger(CycleTargetScheduler.class);
    public static final String C1 = "C1";
    public static final String C2 = "C2";
    public static final String C3 = "C3";
    public static final String C4 = "C4";

    public CycleTargetScheduler(ApplicationEventPublisher publisher, SendInfoDao sendInfoDao) {
        super(publisher, sendInfoDao);
    }

    @DistributeLock(value="C1")
    @ProcessFeasible(name=Constants.JobName.C14, min=5)
    @Scheduled(fixedDelayString="${tms.schedule.cycle.default:3000}")
    public void c1TargetSchedule() {
        this.searchEventCtype(Constants.TriggerMethod.C1, "01", Cal.getDay());
    }

    @DistributeLock(value="C2")
    @ProcessFeasible(name=Constants.JobName.C14)
    @Scheduled(fixedDelayString="${tms.schedule.cycle.default:6000}")
    public void c2TargetSchedule() {
        this.searchEventCtype(Constants.TriggerMethod.C2, "02", Cal.getWeekDay());
    }

    @DistributeLock(value="C3")
    @ProcessFeasible(name=Constants.JobName.C14)
    @Scheduled(fixedDelayString="${tms.schedule.cycle.default:6000}")
    public void c3TargetSchedule() {
        this.searchEventCtype(Constants.TriggerMethod.C3, "03", null);
    }

    @DistributeLock(value="C4")
    @ProcessFeasible(name=Constants.JobName.C14)
    @Scheduled(fixedDelayString="${tms.schedule.cycle.default:6000}")
    public void c4TargetSchedule() {
        this.searchEventCtype(Constants.TriggerMethod.C4, "04", null);
    }
}

