/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.realtime;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.module.CheckerPossible;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.trans.schedule.realtime.CreateRealtimeScheduler;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@EnableScheduling
public class CreatorOnceAdayRealtimeScheduler
extends CreateRealtimeScheduler {
    private static final Logger log = LoggerFactory.getLogger(CreatorOnceAdayRealtimeScheduler.class);
    @Autowired
    @Qualifier(value="CheckerDuplicationForRegist")
    protected CheckerPossible<TmsSendInfo> checkerDuplicationForRegist;
    @Autowired
    @Qualifier(value="CheckerDoingWorkOfYesterday")
    protected CheckerPossible<TmsSendInfo> checkerDoingWorkOfYesterday;

    @PostConstruct
    protected void mergeCheckerRealtimeSchedule() {
        this.checkerDeletedInSiteAndCamp.setNextChecker(this.checkerDuplicationForRegist).setNextChecker(this.checkerDoingWorkOfYesterday);
    }

    @Scheduled(fixedDelay=60000L)
    @DistributeLock(value="once.a.day.scheduler.realtime")
    @ProcessFeasible(name=Constants.JobName.C5)
    public void onceAdayScheduleForRealtime() {
        if (log.isDebugEnabled()) {
            log.debug("run realtime schedule at once a day");
        }
        this.realtimeSchedule(this.checkerDeletedInSiteAndCamp, "30");
        if (log.isDebugEnabled()) {
            log.debug("finish realtime schedule at once a day");
        }
    }

    @Override
    protected void createRealtimeSchedule(CheckerPossible<TmsSendInfo> checker, TmsSendInfo tmsSendInfo) {
        String failMessage;
        if (!this.realtimeScheduleFactory.createScheduler(tmsSendInfo, checker) && !ObjectUtils.isEmpty((Object)(failMessage = this.realtimeScheduleFactory.getFailMessage()))) {
            if (failMessage.indexOf("existed(duplicate)") > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("failed creating schd_info/schd_target for next day realtime(C5). [send_id={}] cause[{}]", (Object)tmsSendInfo.getSEND_ID(), (Object)this.realtimeScheduleFactory.getFailMessage());
                }
                return;
            }
            log.info("failed creating schd_info/schd_target for next day realtime(C5). [send_id={}] cause[{}]", (Object)tmsSendInfo.getSEND_ID(), (Object)this.realtimeScheduleFactory.getFailMessage());
        }
    }
}

