/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.realtime;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.custom.realtime.AddCheckerOfRealtime;
import com.humuson.tms.trans.module.CheckerPossible;
import com.humuson.tms.trans.repository.dao.RealtimeDao;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.trans.schedule.realtime.CreateRealtimeScheduler;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@EnableScheduling
public class CreatorChangedRealtimeScheduler
extends CreateRealtimeScheduler {
    private static final Logger log = LoggerFactory.getLogger(CreatorChangedRealtimeScheduler.class);
    @Autowired
    @Qualifier(value="CheckerChangedScheduler")
    private CheckerPossible<TmsSendInfo> checkerChangedScheduler;
    @Autowired
    @Qualifier(value="CheckerQuerySentenceInRealtime")
    private CheckerPossible<TmsSendInfo> CheckerQuerySentenceInRealtime;
    @Autowired
    @Qualifier(value="CheckerExistUpdateQuery")
    private CheckerPossible<TmsSendInfo> checkerExistUpdateQuery;
    @Autowired(required=false)
    private AddCheckerOfRealtime addCheckerOfRealtime;
    @Autowired
    protected RealtimeDao realtimeDao;

    @PostConstruct
    public void initial() {
        this.checkerDeletedInSiteAndCamp.setNextChecker(this.checkerChangedScheduler).setNextChecker(this.checkerExistUpdateQuery).setNextChecker(this.CheckerQuerySentenceInRealtime);
        if (!ObjectUtils.isEmpty((Object)this.addCheckerOfRealtime)) {
            this.addCheckerOfRealtime.add(this.checkerDeletedInSiteAndCamp);
        }
    }

    @Scheduled(fixedDelay=3000L)
    @DistributeLock(value="once.a.day.scheduler.realtime")
    @ProcessFeasible(name=Constants.JobName.C5)
    public void creatorSchedulerForRealtime() {
        if (log.isDebugEnabled()) {
            log.debug("run real time schedule at 3sec");
        }
        this.realtimeSchedule(this.checkerDeletedInSiteAndCamp, "10");
        if (log.isDebugEnabled()) {
            log.debug("finish real time schedule at 3sec");
        }
    }

    @Override
    protected void createRealtimeSchedule(CheckerPossible<TmsSendInfo> checker, TmsSendInfo tmsSendInfo) {
        this.realtimeDao.updateSendInfoJobStatus(tmsSendInfo.getSEND_ID(), "15");
        if (this.realtimeScheduleFactory.createScheduler(tmsSendInfo, this.checkerDeletedInSiteAndCamp)) {
            log.info("create or chanaged real time scheduler SEND_INFO[{}] ", (Object)tmsSendInfo);
        } else {
            String failMessage = this.realtimeScheduleFactory.getFailMessage();
            log.info("don't create real time schedule. Fail Message={} \n SEND_INFO[{}]", (Object)failMessage, (Object)tmsSendInfo);
        }
    }
}

