/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule.realtime;

import com.humuson.tms.trans.module.CheckerPossible;
import com.humuson.tms.trans.module.realtime.RealtimeScheduleFactory;
import com.humuson.tms.trans.repository.dao.RealtimeDao;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.ObjectUtils;

public abstract class CreateRealtimeScheduler {
    private static final Logger log = LoggerFactory.getLogger(CreateRealtimeScheduler.class);
    protected static final String REALTIME_NODE = "once.a.day.scheduler.realtime";
    @Autowired
    protected RealtimeDao realtimeDao;
    @Autowired
    @Qualifier(value="CheckerDeletedInSiteAndCamp")
    protected CheckerPossible<TmsSendInfo> checkerDeletedInSiteAndCamp;
    @Autowired
    protected RealtimeScheduleFactory realtimeScheduleFactory;

    protected void realtimeSchedule(CheckerPossible<TmsSendInfo> checker, String jobStatus) {
        try {
            List<TmsSendInfo> tmsSendInfos = this.realtimeDao.selectTmsSendInfoForCreateSchedule(jobStatus);
            if (ObjectUtils.isEmpty(tmsSendInfos)) {
                return;
            }
            for (TmsSendInfo tmsSendInfo : tmsSendInfos) {
                try {
                    this.createRealtimeSchedule(checker, tmsSendInfo);
                }
                catch (Exception e) {
                    String message = "";
                    if ("10".equals(jobStatus)) {
                        message = "create/changed";
                    } else if ("30".equals(jobStatus)) {
                        message = "next day created";
                    }
                    log.error("DS1102| error real-time {} so update(41). send-info[{}]", new Object[]{message, tmsSendInfo, e});
                    this.updateStopSendInfoSchedule(tmsSendInfo.getSEND_ID());
                }
            }
        }
        catch (Exception e) {
            log.error("DS1100| selectTmsSendInfoForCreateSchedule error return null. {}", (Throwable)e);
        }
    }

    private void updateStopSendInfoSchedule(long sendId) {
        this.realtimeDao.updateSendInfoJobStatus(sendId, "31");
    }

    protected abstract void createRealtimeSchedule(CheckerPossible<TmsSendInfo> var1, TmsSendInfo var2);
}

