/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.repository.dao.UploadFilterInfoDao;
import com.humuson.tms.trans.upload.UploadFilterInfoService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.schedule.use", name={"filter"}, havingValue="true", matchIfMissing=false)
public class UploadFilterInfoScheduler {
    private static final Logger log = LoggerFactory.getLogger(UploadFilterInfoScheduler.class);
    @Autowired
    private WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    UploadFilterInfoService uploadToRedisFilterService;
    @Autowired
    @Qualifier(value="asyncJobLauncher")
    JobLauncher asyncJobLauncher;
    @Autowired
    JobRepository jobRepository;
    @Autowired
    UploadFilterInfoDao uploadFilterInfoDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProcessFeasible(name=Constants.JobName.EM_BOUND, min=60)
    @DistributeLock(value="lock.data.scheduler.upload.filter")
    @Scheduled(fixedDelayString="${tms.schedule.filter:300000}")
    public void uploadFilterScheduler() {
        Map redisMap = null;
        try {
            log.info("===================================LOCK_DATASCHEDULER_UPLOAD_FILTER=========================================");
            redisMap = this.wrapperRedisTemplate.hgetAllString("DINDI");
            log.info("INDICATOR_HARD : {}", redisMap.get("UploadHardbounce"));
            log.info("INDICATOR_SITE : {}", redisMap.get("UploadSiteUser"));
            log.info("INDICATOR_BMKT : {}", redisMap.get("UploadPushBMKT"));
            String indiHard = redisMap.get("UploadHardbounce") != null ? (String)redisMap.get("UploadHardbounce") : "-1";
            String indiSite = redisMap.get("UploadSiteUser") != null ? (String)redisMap.get("UploadSiteUser") : "-1";
            String indiBmkt = redisMap.get("UploadPushBMKT") != null ? (String)redisMap.get("UploadPushBMKT") : "-1";
            long nowRedisCntMhard = this.wrapperRedisTemplate.hlen("MHARD");
            if (nowRedisCntMhard == 0L) {
                indiHard = "-1";
            }
            long nowRedisCntMmkt = 0L;
            List<Map<String, String>> sitesUserCnts = this.uploadFilterInfoDao.selectSiteUserCnt(null, 0);
            StringBuffer mmktbuf = new StringBuffer();
            int indexMmkt = 0;
            String targetSiteId = null;
            for (Map<String, String> targetCntMap : sitesUserCnts) {
                targetSiteId = String.valueOf(targetCntMap.get("SITE_ID"));
                nowRedisCntMmkt = this.wrapperRedisTemplate.hlen("MMKT:" + targetSiteId);
                List<Map<String, String>> targetList = this.uploadFilterInfoDao.selectSiteUserCnt(indiSite, Integer.parseInt(targetSiteId));
                if ((nowRedisCntMmkt != 0L || Integer.parseInt(String.valueOf(targetCntMap.get("USER_CNT"))) <= 0) && (targetList == null || targetList.size() <= 0 || Integer.parseInt(String.valueOf(targetList.get(0).get("USER_CNT"))) <= 0)) continue;
                mmktbuf.append(indexMmkt).append(",");
                mmktbuf.append(targetSiteId).append("|");
                ++indexMmkt;
            }
            if (mmktbuf.length() > 0) {
                mmktbuf.delete(mmktbuf.length() - 1, mmktbuf.length());
                log.info("mmktbuf: {}", (Object)mmktbuf.toString());
            }
            long nowRedisCntBmkt = 0L;
            List<Map<String, String>> appDeviceCnts = this.uploadFilterInfoDao.selectAppDeviceCnt(null, 0);
            StringBuffer bmktbuf = new StringBuffer();
            int indexBmkt = 0;
            for (Map<String, String> targetCntMap : appDeviceCnts) {
                targetSiteId = String.valueOf(targetCntMap.get("SITE_ID"));
                nowRedisCntBmkt = this.wrapperRedisTemplate.hlen("BMKT:" + targetSiteId);
                List<Map<String, String>> targetList = this.uploadFilterInfoDao.selectAppDeviceCnt(indiSite, Integer.parseInt(targetSiteId));
                if ((nowRedisCntBmkt != 0L || Integer.parseInt(String.valueOf(targetCntMap.get("USER_CNT"))) <= 0) && (targetList == null || targetList.size() <= 0 || Integer.parseInt(String.valueOf(targetList.get(0).get("USER_CNT"))) <= 0)) continue;
                bmktbuf.append(indexBmkt).append(",");
                bmktbuf.append(targetSiteId).append("|");
                ++indexBmkt;
            }
            if (bmktbuf.length() > 0) {
                bmktbuf.delete(bmktbuf.length() - 1, bmktbuf.length());
                log.info("bmktbuf: {}", (Object)bmktbuf.toString());
            }
            JobParameters jobParameters = new JobParametersBuilder().addLong("time", Long.valueOf(System.currentTimeMillis())).addString("UploadHardbounce", indiHard).addString("UploadSiteUser", indiSite).addString("UploadPushBMKT", indiBmkt).addString("mmktStr", mmktbuf.toString()).addString("bmktStr", bmktbuf.toString()).toJobParameters();
            this.asyncJobLauncher.run(this.getJob(), jobParameters);
        }
        catch (Exception e) {
            log.error("DS0155|Redis::[{}] ERROR:{}", (Object)"DINDI", (Object)e);
        }
        finally {
            redisMap.clear();
            redisMap = null;
        }
    }

    public Job getJob() {
        return this.uploadToRedisFilterService.job();
    }
}

