/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.trans.repository.dao.UploadAppInfoDao;
import com.humuson.tms.trans.repository.model.AppInfo;
import com.humuson.tms.util.FileUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.schedule.use", name={"ainfo"}, havingValue="true", matchIfMissing=false)
public class UploadAppInfoScheduler {
    private static final Logger log = LoggerFactory.getLogger(UploadAppInfoScheduler.class);
    @Autowired
    private WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    private UploadAppInfoDao uploadToRedisAppDao;

    @ProcessFeasible(name=Constants.JobName.PUSH_APP)
    @DistributeLock(value="lock.data.scheduler.upload.app")
    @Scheduled(fixedDelayString="${tms.schedule.app-info:300000}")
    public void uploadAppScheduler() {
        try {
            log.info("===================================LOCK_DATASCHEDULER_UPLOAD_APP=========================================");
            List<AppInfo> appInfoList = this.uploadToRedisAppDao.selectAppInfo();
            HashMap<Integer, Map<String, String>> uploadAppMap = new HashMap<Integer, Map<String, String>>();
            Map target = new HashMap();
            for (AppInfo aim : appInfoList) {
                byte[] fileString;
                String encodeByte;
                String filePath;
                target = uploadAppMap.get(aim.getAppGrpId()) != null ? (Map)uploadAppMap.get(aim.getAppGrpId()) : new HashMap();
                if ("I".equals(aim.getOs())) {
                    filePath = null;
                    filePath = aim.getPushCert();
                    encodeByte = null;
                    try {
                        fileString = FileUtil.getApnsFile((String)filePath);
                        encodeByte = Base64.encodeBase64String((byte[])fileString);
                    }
                    catch (Exception e) {
                        log.error("{}|{} is not found cert file. {} ", new Object[]{"DS0701", String.valueOf(aim.getAppId()), e});
                    }
                    if (encodeByte != null && aim.getPushPwd() != null) {
                        target.put("I_APP_ID", String.valueOf(aim.getAppId()));
                        target.put("I_PUSH_CERT", encodeByte);
                        target.put("I_PUSH_PWD", aim.getPushPwd());
                        target.put("I_BADGE_FLAG", aim.getBadgeFlag());
                        target.put("I_SOUND", aim.getPushSound());
                    }
                } else if ("A".equals(aim.getOs())) {
                    target.put("A_APP_ID", String.valueOf(aim.getAppId()));
                    target.put("A_PROJECT_NUM", aim.getProjectNum());
                    target.put("A_API_KEY", aim.getApiKey());
                } else if ("AI".equals(aim.getOs())) {
                    filePath = null;
                    filePath = aim.getPushCert();
                    encodeByte = null;
                    try {
                        fileString = FileUtil.getApnsFile((String)filePath);
                        encodeByte = Base64.encodeBase64String((byte[])fileString);
                    }
                    catch (Exception e) {
                        log.error("{}|{} is not found cert file. {} ", new Object[]{"DS0701", String.valueOf(aim.getAppId()), e});
                    }
                    if (encodeByte != null && aim.getPushPwd() != null) {
                        target.put("I_APP_ID", String.valueOf(aim.getAppId()));
                        target.put("I_PUSH_CERT", encodeByte);
                        target.put("I_PUSH_PWD", aim.getPushPwd());
                        target.put("I_BADGE_FLAG", aim.getBadgeFlag());
                        target.put("I_SOUND", aim.getPushSound());
                    }
                    target.put("A_APP_ID", String.valueOf(aim.getAppId()));
                    target.put("A_PROJECT_NUM", aim.getProjectNum());
                    target.put("A_API_KEY", aim.getApiKey());
                }
                target.put("BLOCK_START", aim.getAutoBlockStart());
                target.put("BLOCK_END", aim.getAutoBlockEnd());
                if (this.checkUpload((String)target.get("UPLOAD_DATE"), aim.getUptDate())) {
                    target.put("UPLOAD_DATE", aim.getUptDate());
                }
                uploadAppMap.put(aim.getAppGrpId(), target);
            }
            Iterator keys = uploadAppMap.keySet().iterator();
            while (keys.hasNext()) {
                int appGrpId = (Integer)keys.next();
                String redisKey = "AINFO:" + appGrpId;
                this.wrapperRedisTemplate.hmsetAll(redisKey, (Map)uploadAppMap.get(appGrpId));
            }
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
            log.error("DS0154|Redis::[{}] ERROR:{}", (Object)"AINFO", (Object)e);
        }
    }

    public boolean checkUpload(String saved, String now) {
        if (saved == null) {
            return true;
        }
        long savedDate = Long.parseLong(saved);
        long nowDate = Long.parseLong(now);
        return nowDate > savedDate;
    }
}

