/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.util.date.DateUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnBean(name={"sentinelRedisConfig"})
public class LiveScheduler {
    private static final Logger log = LoggerFactory.getLogger(LiveScheduler.class);
    @Autowired
    protected WrapperRedisTemplate wrapperRedisTemplate;
    @Value(value="${tms.daemon-type}")
    private String daemonType;
    @Value(value="${tms.daemon-id}")
    String daemonId;
    protected Logger liveTraceLogger = LoggerFactory.getLogger((String)"liveTraceLog");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProcessFeasible(name=Constants.JobName.LIVE)
    @Scheduled(fixedDelayString="${tms.schedule.live-check:10000}")
    public void statusMonitor() {
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
        DecimalFormat df = new DecimalFormat("#0");
        String smemUsed = df.format((double)memUsage.getUsed() / 1048576.0);
        String smemMax = df.format((double)memUsage.getMax() / 1048576.0);
        String[] dates = DateUtil.getDivideDateDefault();
        String redisKey = "JSTAT:DS";
        String field = this.daemonId + ":" + dates[0];
        if (Integer.parseInt(smemUsed) * 100 / Integer.parseInt(smemMax) > 80) {
            log.info("Redis::[CheckLive] KEY:{}, FIELD:{}, DATA:{} / max {} MB used {} MB", new Object[]{redisKey, field, dates[1], smemMax, smemUsed});
        }
        try {
            String oldValue = this.wrapperRedisTemplate.hmget(redisKey, field);
            oldValue = oldValue == null ? "" : oldValue + "|";
            this.wrapperRedisTemplate.hmset(redisKey, field, oldValue + dates[1] + ":" + smemMax + ":" + smemUsed);
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
            log.error("DS0145|Redis::[CheckLive] {}, {}, ERROR:{}", new Object[]{redisKey, field, e});
        }
    }
}

