/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.repository.model.redis;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class JsonConvertUtil {
    public static <T extends Serializable> String objectToJsonString(T t) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
        return mapper.writeValueAsString(t);
    }

    public static <T extends Serializable> String objectToJsonStringNullFilter(T t) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper.writeValueAsString(t);
    }

    public static String beanToJsonString(Object o) throws Exception {
        return new ObjectMapper().writeValueAsString(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String listBeanToJsonString(List<T> o) throws Exception {
        try (StringWriter sw = new StringWriter();){
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue((Writer)sw, o);
            String string = sw.toString();
            return string;
        }
    }

    public static <T extends Serializable> String mapToJsonString(Map t) throws Exception {
        return new ObjectMapper().writeValueAsString((Object)t);
    }

    public static <T extends Serializable> T jsonStringToObject(String jsonString, Class<T> clz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (T)((Serializable)mapper.readValue(jsonString, clz));
    }
}

