/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.test;

import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.TmsBatchTargetInfoFactory;
import com.humuson.tms.trans.module.batch.TmsBatchDbTargetExecutor;
import com.humuson.tms.trans.module.batch.TmsBatchTargetInfo;
import com.humuson.tms.trans.module.query.TestQueryAssembly;
import com.humuson.tms.trans.repository.dao.TestSendInfoDao;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSchdTarget;
import com.humuson.tms.trans.repository.model.TmsTargetLinkQueryInfo;
import com.humuson.tms.trans.repository.model.TmsTestInfo;
import com.humuson.tms.trans.repository.model.TmsTestTargetUser;
import com.humuson.tms.trans.util.ObjectUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public abstract class TestSender {
    private static final Logger log = LoggerFactory.getLogger(TestSender.class);
    @Autowired
    protected TestSendInfoDao testSendInfoDao;
    @Autowired
    protected TestQueryAssembly testQueryAssembly;
    @Autowired
    TmsBatchTargetInfoFactory batchTargetInfoFactory;
    @Autowired
    TmsBatchDbTargetExecutor executor;
    @Value(value="${tms.tracking.close.day:7}")
    private int tracking_close;
    protected TmsTestInfo testInfo;
    private String JOB_STATUS_RESULT;

    public void setTmsTestInfo(TmsTestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public boolean assembleTestQuery() {
        boolean isComplete = true;
        TmsTargetLinkQueryInfo targetLinkQueryInfo = this.getTargetLinkQueryInfo(this.testInfo.getTARGET_ID());
        if (targetLinkQueryInfo == null) {
            this.failLogAssembleTestQuery();
            return false;
        }
        try {
            this.assembleTestQuery(targetLinkQueryInfo);
            if (log.isDebugEnabled()) {
                log.debug("maked test query [{}]", (Object)targetLinkQueryInfo.getTEST_QUERY());
            }
        }
        catch (Exception e) {
            isComplete = false;
            log.error("DS0141||failed assemble test-id[{}] test query info[{}] so update job_status(41) ", new Object[]{this.testInfo.getTEST_ID(), targetLinkQueryInfo, e});
            this.updateTestJobStatus(this.testInfo.getTEST_ID(), "41");
        }
        this.testInfo.setTargetLinkQueryInfo(targetLinkQueryInfo);
        return isComplete;
    }

    private void updateTestFinishJobStatus(int testId, long schdId, String JOB_STATUS_RESULT) {
        this.updateTestJobStatus(testId, JOB_STATUS_RESULT);
        try {
            if (JOB_STATUS_RESULT.equals("30")) {
                JOB_STATUS_RESULT = "10";
            }
            this.testSendInfoDao.updateSchdInfoJobStatus(schdId, JOB_STATUS_RESULT);
        }
        catch (Exception e) {
            log.error("DS0137| Test schd info update error TMS_SCHD_INFO SCHD_ID[{}], job_status[{}] ", new Object[]{schdId, JOB_STATUS_RESULT, e});
        }
    }

    protected void updateTestJobStatus(int testId, String JOB_STATUS_RESULT) {
        try {
            this.testSendInfoDao.updateTestInfoResult(testId, JOB_STATUS_RESULT);
        }
        catch (Exception e2) {
            log.error("DS0138| Test send update error tmsTestInfo testId[{}], job_status[{}] ", new Object[]{"DS0505", testId, JOB_STATUS_RESULT, e2});
        }
    }

    public void executeTarget(long schdId) {
        try {
            TmsBatchTargetInfo tmsBatchTargetInfo = this.batchTargetInfoFactory.createBatchTargetInfo(this.testInfo);
            tmsBatchTargetInfo.setSCHD_ID(schdId);
            this.executor.execute(tmsBatchTargetInfo);
        }
        catch (Exception e) {
            log.error("test targeting error send_id[{}]", (Object)this.testInfo.getSEND_ID(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void registTestScheduler() {
        block10: {
            this.JOB_STATUS_RESULT = "30";
            long schdId = -1L;
            schdId = this.insertTestScheduler();
            this.executeTarget(schdId);
            try {
                this.updateTestFinishJobStatus(this.testInfo.getTEST_ID(), schdId, this.JOB_STATUS_RESULT);
            }
            catch (Exception e2) {
                log.error("DS0140| error update job-status[{}]. test-id={}", new Object[]{"DS0506", this.JOB_STATUS_RESULT, this.testInfo.getTEST_ID()});
            }
            break block10;
            catch (Exception e) {
                try {
                    log.error("DS0139|test send[{}] insert error. job-status into 41", (Object)this.testInfo, (Object)e);
                    this.JOB_STATUS_RESULT = "41";
                }
                catch (Throwable throwable) {
                    try {
                        this.updateTestFinishJobStatus(this.testInfo.getTEST_ID(), schdId, this.JOB_STATUS_RESULT);
                    }
                    catch (Exception e2) {
                        log.error("DS0140| error update job-status[{}]. test-id={}", new Object[]{"DS0506", this.JOB_STATUS_RESULT, this.testInfo.getTEST_ID()});
                    }
                    throw throwable;
                }
                try {
                    this.updateTestFinishJobStatus(this.testInfo.getTEST_ID(), schdId, this.JOB_STATUS_RESULT);
                }
                catch (Exception e2) {
                    log.error("DS0140| error update job-status[{}]. test-id={}", new Object[]{"DS0506", this.JOB_STATUS_RESULT, this.testInfo.getTEST_ID()});
                }
            }
        }
    }

    @Transactional
    private long insertTestScheduler() throws Exception {
        TmsSchdInfo tmsSchdInfo = new TmsSchdInfo();
        ObjectUtil.objectMerge(tmsSchdInfo, this.testInfo, this.testInfo.getTargetLinkQueryInfo());
        this.setAddField(tmsSchdInfo);
        this.testSendInfoDao.insertTmsSchdInfo(tmsSchdInfo);
        this.insertSchdTarget(tmsSchdInfo);
        return tmsSchdInfo.getSCHD_ID();
    }

    protected void setAddSchdTargetField(TmsSchdTarget tmsSchdTarget, TmsTargetLinkQueryInfo targetListQueryInfo) {
        tmsSchdTarget.setTARGET_DB_ID(targetListQueryInfo.getDB_ID());
        tmsSchdTarget.setTARGET_QUERY_S(targetListQueryInfo.getTEST_QUERY());
    }

    private void setAddField(TmsSchdInfo tmsSchdInfo) {
        tmsSchdInfo.setWORKDAY(DateUtil.getWorkday());
        tmsSchdInfo.setJOB_STATUS("00");
        tmsSchdInfo.setDEL_YN("N");
        tmsSchdInfo.setWORKING_YN("N");
        tmsSchdInfo.setTRIGGER_METHOD(Constants.TriggerMethod.O8.name());
        tmsSchdInfo.setINIT_TARGET(this.testSendInfoDao.getTestQueryCount(tmsSchdInfo.getTEST_ID()));
        String trackingClose = this.testSendInfoDao.selectControlInfo(tmsSchdInfo.getSEND_ID()).getTRACKING_CLOSE();
        tmsSchdInfo.setTRACKING_CLOSE(StringUtils.isEmpty((String)trackingClose) ? DateUtil.addDate((String)"yyyy-MM-dd", (int)this.tracking_close) : trackingClose);
        tmsSchdInfo.setGRP_ID("" + System.currentTimeMillis());
    }

    protected List<TmsTestTargetUser> getTestTargetUser() {
        return this.testSendInfoDao.selectTestTarget(this.testInfo.getTEST_ID());
    }

    protected abstract void assembleTestQuery(TmsTargetLinkQueryInfo var1) throws Exception;

    protected abstract TmsTargetLinkQueryInfo getTargetLinkQueryInfo(int var1);

    protected abstract void failLogAssembleTestQuery();

    protected abstract void insertSchdTarget(TmsSchdInfo var1) throws Exception;
}

