/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.test;

import com.humuson.tms.batch.FileReader;
import com.humuson.tms.trans.module.test.TestSender;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSchdTarget;
import com.humuson.tms.trans.repository.model.TmsTargetLinkQueryInfo;
import com.humuson.tms.trans.repository.model.TmsTargetTemp;
import com.humuson.tms.trans.util.ObjectUtil;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.convert.TransObjectUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileTestSender
extends TestSender {
    private static final Logger log = LoggerFactory.getLogger(FileTestSender.class);
    @Autowired
    private FileReader<Object> fileReader;
    private static final int LOCAL_DB_ID = -1;

    @Override
    protected TmsTargetLinkQueryInfo getTargetLinkQueryInfo(int targetId) {
        return this.testSendInfoDao.selectFileTargetLinkQueryInfo(targetId);
    }

    @Override
    protected void failLogAssembleTestQuery() {
        log.error("{}|Failed to make file test Query. target id = {} ", (Object)"DS0507", (Object)this.testInfo.getTARGET_ID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void assembleTestQuery(TmsTargetLinkQueryInfo targetLinkQueryInfo) throws Exception {
        Map map = TransObjectUtil.convertObjectToMap((Object)targetLinkQueryInfo);
        Map result = null;
        try (FlatFileItemReader itemReader = null;){
            itemReader = (FlatFileItemReader)this.fileReader.getReaderByMap(map);
            this.setLimitFileLineCountForTest(map, (FlatFileItemReader<Map<String, Object>>)itemReader);
            ExecutionContext context = new ExecutionContext();
            itemReader.open(context);
            result = (Map)itemReader.read();
        }
        result.put("TARGET_FLAG", "N");
        result.put("SEND_ID", this.testInfo.getSEND_ID());
        result.put("TARGET_ID", this.testInfo.getTARGET_ID());
        result.put("ETC", JsonUtil.convertMapToJsonString((Map)result));
        result.put("WORKDAY", DateUtil.getWorkday());
        TmsTargetTemp targetTemp = (TmsTargetTemp)TransObjectUtil.mapToBean(TmsTargetTemp.class, (Map)result);
        int grpSeq = this.testSendInfoDao.selectTmsTargetTmpMaxGrpSeq(this.testInfo.getSEND_ID());
        result.put("GRP_SEQ", grpSeq);
        targetTemp.setGRP_SEQ(grpSeq);
        this.testSendInfoDao.insertTmsTargetTemp(targetTemp);
        log.info("test file target insert tms_target_temp send_id={}, grp_seq={}", (Object)this.testInfo.getSEND_ID(), (Object)targetTemp.getGRP_SEQ());
        targetLinkQueryInfo.setTEST_QUERY(this.makeTargetTempQuery(this.testInfo.getCHANNEL_TYPE(), TransObjectUtil.convertObjectToMap((Object)targetTemp)));
        targetLinkQueryInfo.setTARGET_TYPE("DB");
    }

    private void setLimitFileLineCountForTest(Map<String, Object> fileTargetInfo, FlatFileItemReader<Map<String, Object>> itemReader) {
        if ("Y".equals(fileTargetInfo.get("TARGET_FILE_HEAD_FLAG"))) {
            itemReader.setCurrentItemCount(1);
            itemReader.setMaxItemCount(2);
        } else {
            itemReader.setMaxItemCount(1);
        }
    }

    private String makeTargetTempQuery(String channelType, Map<String, Object> result) throws Exception {
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("MAPPERS");
        return this.testQueryAssembly.makeSelectQueryOfTargetTempList(channelType, result, filter, this.getTestTargetUser());
    }

    @Override
    protected void insertSchdTarget(TmsSchdInfo tmsSchdInfo) throws Exception {
        TmsSchdTarget tmsSchdTarget = new TmsSchdTarget();
        TmsTargetLinkQueryInfo targetLinkQueryInfo = this.testInfo.getTargetLinkQueryInfo();
        ObjectUtil.objectMerge(tmsSchdTarget, tmsSchdInfo, this.testInfo, targetLinkQueryInfo);
        tmsSchdTarget.setTARGET_TYPE("DB");
        tmsSchdTarget.setTARGET_DB_ID(-1);
        tmsSchdTarget.setCT_TARGET_TYPE("DB");
        tmsSchdTarget.setTARGET_QUERY_S(targetLinkQueryInfo.getTEST_QUERY());
        tmsSchdTarget.setTARGET_FILE_ID(targetLinkQueryInfo.getFILE_ID());
        this.testSendInfoDao.insertTmsSchdTarget(tmsSchdTarget);
    }
}

