/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.test;

import com.humuson.tms.trans.module.query.QueryOptimizer;
import com.humuson.tms.trans.module.test.TestSender;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSchdTarget;
import com.humuson.tms.trans.repository.model.TmsTargetLinkQueryInfo;
import com.humuson.tms.trans.util.ObjectUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BasicTestSender
extends TestSender {
    private static final Logger log = LoggerFactory.getLogger(BasicTestSender.class);

    @Override
    protected TmsTargetLinkQueryInfo getTargetLinkQueryInfo(int targetId) {
        return this.testSendInfoDao.selectOneTargetLinkQueryInfo(targetId, "10");
    }

    @Override
    protected void failLogAssembleTestQuery() {
        log.error("{}|Failed query_type[10] does not exists. target id = {} ", (Object)"DS0508", (Object)this.testInfo.getTARGET_ID());
    }

    @Override
    protected void assembleTestQuery(TmsTargetLinkQueryInfo targetLinkQueryInfo) throws Exception {
        QueryOptimizer queryOptimizer = this.testQueryAssembly.getQueryOptimizer(targetLinkQueryInfo.getDB_TYPE());
        queryOptimizer.setDbId(targetLinkQueryInfo.getDB_ID());
        String selectQuery = targetLinkQueryInfo.getQUERY();
        if (this.isExistAddWhereQuery()) {
            selectQuery = "SELECT * FROM ( " + selectQuery + " ) Z WHERE " + this.testInfo.getADD_WHERE_QUERY();
        }
        String limitOneSelectQuery = queryOptimizer.makeOnlyOneSql(selectQuery);
        Map<String, Object> columns = queryOptimizer.getColumns(limitOneSelectQuery);
        String testQuery = this.testQueryAssembly.makeTestQuery(this.testInfo.getCHANNEL_TYPE(), columns, limitOneSelectQuery, this.getTestTargetUser());
        targetLinkQueryInfo.setTEST_QUERY(testQuery);
    }

    private boolean isExistAddWhereQuery() {
        return !StringUtils.isEmpty((CharSequence)this.testInfo.getADD_WHERE_QUERY());
    }

    @Override
    protected void insertSchdTarget(TmsSchdInfo tmsSchdInfo) throws Exception {
        TmsSchdTarget tmsSchdTarget = new TmsSchdTarget();
        TmsTargetLinkQueryInfo targetLinkQueryInfo = this.testInfo.getTargetLinkQueryInfo();
        ObjectUtil.objectMerge(tmsSchdTarget, tmsSchdInfo, this.testInfo, targetLinkQueryInfo);
        tmsSchdTarget.setTARGET_DB_ID(targetLinkQueryInfo.getDB_ID());
        tmsSchdTarget.setTARGET_QUERY_S(targetLinkQueryInfo.getTEST_QUERY());
        tmsSchdTarget.setCT_TARGET_TYPE("DB");
        tmsSchdTarget.setTARGET_TYPE("DB");
        this.testSendInfoDao.insertTmsSchdTarget(tmsSchdTarget);
    }
}

