/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.rest;

import com.humuson.tms.adaptor.jdbc.DynamicJdbcTemplate;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.adaptor.jdbc.mybatis.DynamicMapSqlMapper;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcTemplate;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.crypto.HumusonDecryptor;
import com.humuson.tms.trans.repository.dao.rest.ApiTargetCountDao;
import com.humuson.tms.trans.util.StringUtil;
import com.humuson.tms.util.FileExtentionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import javax.sql.DataSource;
import org.aspectj.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(name={"defaultDatabaseConfig", "dynamicMapSqlMapper"})
public class TargetCounterUtil {
    private static final Logger log = LoggerFactory.getLogger(TargetCounterUtil.class);
    @Autowired
    DefaultDatabaseConfig defaultDatabaseConfig;
    @Autowired
    ApiTargetCountDao apiTargetCountDao;
    @Autowired
    FileExtentionUtil extentionUtil;
    @Autowired
    DynamicMapSqlMapper mapper;
    @Autowired
    DynamicJdbcTemplate dyJdbcTemplate;
    @Autowired
    @Qualifier(value="tmsDatasource")
    DataSource dataSource;
    @Autowired
    TmsCommonConfig tmsConfig;
    @Value(value="${tms.localFile}")
    public boolean localFile;

    public long getFileTargetCount(long sendId, String fileName, String headFlag, String regId) throws Exception {
        HashMap<String, Object> targetInfo = new HashMap();
        targetInfo = this.apiTargetCountDao.selectTargetFileInfo(sendId, regId);
        if (!StringUtil.hasKey(targetInfo, "SEND_ID") && !StringUtil.hasKey(targetInfo, "REG_ID")) {
            throw new Exception("NOT EXIST TMS_SEND_INFO : " + sendId);
        }
        targetInfo.put("SEND_ID", String.valueOf(targetInfo.get("SEND_ID")));
        targetInfo.put("REG_ID", String.valueOf(targetInfo.get("REG_ID")));
        targetInfo.put("TARGET_FILE_HEAD_FLAG", headFlag);
        targetInfo.put("TARGET_FILE_NAME", fileName);
        return this.getFileTargetCount(targetInfo);
    }

    public long getDbTargetCount(long sendId, long targetId, String regId) throws Exception {
        HashMap<String, Object> mapTargetInfo = this.apiTargetCountDao.selectTargetDbInfo(sendId, targetId, regId);
        if (mapTargetInfo == null || mapTargetInfo.size() == 0 || !StringUtil.hasKey(mapTargetInfo, "DB_ID")) {
            throw new Exception("NOT EXIST TARGET DATA. from  SEND_ID : " + sendId);
        }
        mapTargetInfo.put("TARGET_QUERY_S", String.valueOf(mapTargetInfo.get("QUERY")));
        return this.getDbTargetCount(mapTargetInfo);
    }

    public long getDbTargetCount(HashMap<String, Object> mapTargetInfo) throws Exception {
        String sql = this.makeCountSqlFromTargetSql(mapTargetInfo.get("TARGET_QUERY_S").toString());
        if (!StringUtil.hasKey(mapTargetInfo, "DB_URL") || String.valueOf(mapTargetInfo.get("DB_URL")).equalsIgnoreCase("null")) {
            return this.apiTargetCountDao.selectTargetCount(sql);
        }
        try (TmsJdbcTemplate jdbcTemplate = new TmsJdbcTemplate();){
            jdbcTemplate.db(String.valueOf(mapTargetInfo.get("DB_URL")), String.valueOf(mapTargetInfo.get("DB_DRV")), String.valueOf(mapTargetInfo.get("DB_USR")), HumusonDecryptor.decrypt((String)mapTargetInfo.get("DB_PWD").toString(), (String)this.tmsConfig.getHumusonKey()));
            log.info("web call sql count QUERY[{}]", (Object)sql);
            String count = jdbcTemplate.selectOne(sql).get("CNT").toString();
            long l = Long.parseLong(count);
            return l;
        }
    }

    private String makeCountSqlFromTargetSql(String query) {
        return "SELECT count(*) as CNT FROM (" + query + ") A";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileTargetCount(HashMap<String, Object> mapTargetInfo) throws Exception {
        String fullPathFileName = String.valueOf(mapTargetInfo.get("TARGET_FILE_NAME")).trim();
        if (!this.localFile) {
            fullPathFileName = String.valueOf(mapTargetInfo.get("TARGET_FILE_NAME")).trim();
        } else {
            fullPathFileName = fullPathFileName.substring(fullPathFileName.lastIndexOf("/"), fullPathFileName.length());
            fullPathFileName = "C:/TMS5/tms-web/htdocs/upload" + fullPathFileName.trim();
        }
        mapTargetInfo.put("TARGET_FILE_NAME", fullPathFileName);
        if (!this.extentionUtil.isTargetingFileExtention(fullPathFileName)) {
            log.info("FILE TARGETING START, File is invalid Extention : {}", (Object)fullPathFileName);
            throw new Exception("File Extention is Invalid. file : " + fullPathFileName);
        }
        File targetFile = new File(fullPathFileName);
        if (!targetFile.exists()) {
            log.info("FILE TARGETING START, File is not exist : {}", (Object)fullPathFileName);
            throw new Exception("File is not exist. file : " + fullPathFileName);
        }
        if (!FileUtil.canReadFile((File)targetFile)) {
            log.info("FILE TARGETING START, File can't read : {}", (Object)fullPathFileName);
            throw new Exception("File can't read. file : " + fullPathFileName);
        }
        boolean firstSkip = "Y".equalsIgnoreCase(String.valueOf(mapTargetInfo.get("TARGET_FILE_HEAD_FLAG")));
        int targetCnt = 0;
        int lineToSkipCount = 0;
        if (firstSkip) {
            lineToSkipCount = 1;
        }
        try (BufferedReader lnr = null;){
            String line;
            lnr = new LineNumberReader(new FileReader(targetFile));
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                ++targetCnt;
            }
            log.debug("lineNumber:{}, lineToSkipCount:{}", (Object)((LineNumberReader)lnr).getLineNumber(), (Object)lineToSkipCount);
            targetCnt = ((LineNumberReader)lnr).getLineNumber() - lineToSkipCount;
        }
        return targetCnt;
    }
}

