/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.rest;

import com.humuson.tms.trans.module.rest.ExtractUserByDB;
import com.humuson.tms.util.FileExtentionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.util.FileUtil;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;

@Component
public class ExtractUserByFile {
    private static final Logger log = LoggerFactory.getLogger(ExtractUserByFile.class);
    @Autowired
    FileExtentionUtil extentionUtil;
    @Autowired
    ExtractUserByDB extractUserByDB;
    @Value(value="${tms.localFile}")
    public boolean localFile;
    @Value(value="${tms.resource.target}")
    public String resourcePath;

    public JSONArray getRandomTarget(HashMap<String, Object> mapDispatch, String count) throws Exception {
        List<Map<String, Object>> arrTargetList = this.getRandomTargetFromFile(mapDispatch, Integer.valueOf(count.trim()));
        JSONArray arrTargets = this.extractUserByDB.insertRandomTarget(mapDispatch, arrTargetList);
        return arrTargets;
    }

    public JSONArray getSampleTarget(HashMap<String, Object> mapDispatch, String memberId, String seq) throws Exception {
        JSONArray arrTargets = this.extractUserByDB.getSampleTarget(mapDispatch, memberId, seq);
        return arrTargets;
    }

    public List<Map<String, Object>> getRandomTargetFromFile(HashMap<String, Object> mapDispatch, int count) throws Exception {
        String fullPathFileName = String.valueOf(mapDispatch.get("TARGET_FILE_NAME")).trim();
        if (!this.localFile) {
            fullPathFileName = String.valueOf(mapDispatch.get("TARGET_FILE_NAME")).trim();
        } else {
            fullPathFileName = fullPathFileName.substring(fullPathFileName.lastIndexOf("/"), fullPathFileName.length());
            fullPathFileName = "C:/TMS5/tms-web/htdocs/upload" + fullPathFileName.trim();
        }
        mapDispatch.put("TARGET_FILE_NAME", fullPathFileName);
        if (!this.extentionUtil.isTargetingFileExtention(fullPathFileName)) {
            log.info("FILE TARGETING START, File is invalid Extention : {}", (Object)fullPathFileName);
            throw new Exception("File Extention is Invalid. file : " + fullPathFileName);
        }
        File targetFile = new File(fullPathFileName);
        if (!targetFile.exists()) {
            log.info("FILE TARGETING START, File is not exist : {}", (Object)fullPathFileName);
            throw new Exception("File is not exist. file : " + fullPathFileName);
        }
        if (!FileUtil.canReadFile((File)targetFile)) {
            log.info("FILE TARGETING START, File can't read : {}", (Object)fullPathFileName);
            throw new Exception("File can't read. file : " + fullPathFileName);
        }
        String[] headers = String.valueOf(mapDispatch.get("MAPPING_HEADER")).split("\\|");
        List<Integer> targetFileIdxList = this.getTargetFileIdx(String.valueOf(mapDispatch.get("TARGET_FILE_IDX")));
        String delimiter = String.valueOf(mapDispatch.get("TARGET_FILE_DELIM"));
        ArrayList<Map<String, Object>> arrFileTarget = new ArrayList<Map<String, Object>>();
        File file = new File(String.valueOf(mapDispatch.get("TARGET_FILE_NAME")));
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            int size = 0;
            boolean isSkipFirstLine = String.valueOf(mapDispatch.get("TARGET_FILE_HEAD_FLAG")).equalsIgnoreCase("Y");
            if (isSkipFirstLine) {
                bufferedReader.readLine();
            }
            while ((line = bufferedReader.readLine()) != null) {
                if (size >= count) {
                    break;
                }
                String[] fileRow = line.split(delimiter);
                HashMap<String, Object> target = this.readFileRow(headers, targetFileIdxList, fileRow);
                arrFileTarget.add(target);
                ++size;
            }
        }
        return arrFileTarget;
    }

    public HashMap<String, Object> readFileRow(String[] headers, List<Integer> targetFileIdxList, String[] fileRow) throws Exception {
        HashMap<String, Object> target = new HashMap<String, Object>();
        try {
            int size = targetFileIdxList.size();
            for (int i = 0; i < size; ++i) {
                if (targetFileIdxList.get(i) < 0) continue;
                target.put(headers[i].trim(), fileRow[targetFileIdxList.get(i)]);
            }
        }
        catch (Exception e) {
            log.error("target data bind error [{}]", (Throwable)e);
            throw new BindException((Object)this, "fieldSetBind Error");
        }
        return target;
    }

    public List<Integer> getTargetFileIdx(String targetFileIdx) throws Exception {
        ArrayList<Integer> targetFileIdxList = new ArrayList<Integer>();
        for (String idx : targetFileIdx.split("[|]")) {
            try {
                targetFileIdxList.add(Integer.parseInt(idx));
            }
            catch (Exception e) {
                log.error("idx parse error [targetFileIdx:{}, idx:{}]", (Object)targetFileIdx, (Object)idx);
                targetFileIdxList.add(-1);
            }
        }
        return targetFileIdxList;
    }
}

