/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.rest;

import com.google.gson.Gson;
import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.DBTypeDetector;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.adaptor.jdbc.mybatis.DynamicMapSqlMapper;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsDataSourceProperties;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.crypto.HumusonDecryptor;
import com.humuson.tms.trans.repository.dao.rest.ApiRandomSamplingDao;
import com.humuson.tms.trans.repository.dao.rest.ApiTargetCountDao;
import com.humuson.tms.trans.repository.model.TmsTargetTemp;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.convert.TransObjectUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@DependsOn(value={"defaultDatabaseConfig"})
public class ExtractUserByDB {
    private static final Logger log = LoggerFactory.getLogger(ExtractUserByDB.class);
    @Autowired
    TmsCommonConfig tmsConfig;
    @Autowired
    ApiRandomSamplingDao apiRandomSamplingDao;
    @Autowired
    ApiTargetCountDao apiTargetCountDao;
    @Autowired
    DynamicMapSqlMapper dynamicMapSqlMapper;
    @Autowired
    DefaultDatabaseConfig localDatabase;
    @Autowired(required=false)
    @Qualifier(value="DefaultDataSourceProperties")
    private TmsDataSourceProperties dataSourceProperties;

    public JSONArray getRandomTarget(HashMap<String, Object> mapDispatch, String count) throws Exception {
        DBType dbType = this.searchDBType(String.valueOf(mapDispatch.get("DB_DRV")));
        String query = this.makeCountSqlFromTargetSql(dbType, String.valueOf(mapDispatch.get("TARGET_QUERY_S")), count);
        List<Map<String, Object>> arrTargetList = this.selectRandomTarget(mapDispatch, query);
        JSONArray arrTargets = this.insertRandomTarget(mapDispatch, arrTargetList);
        return arrTargets;
    }

    private DBType searchDBType(String driverClassName) {
        DBType dbType = DBTypeDetector.databaseType((String)driverClassName);
        if (dbType == null) {
            return this.localDatabase.getDbType();
        }
        return dbType;
    }

    public JSONArray getSampleTarget(HashMap<String, Object> mapDispatch, String memberId, String seq) throws Exception {
        mapDispatch.put("TMS_M_ID", memberId);
        mapDispatch.put("SEQ", seq);
        String query = this.dynamicMapSqlMapper.boundConvertSql("com.humuson.tms.dataschd.repository.dao.rest.ApiRandomSamplingDao.selectSamplingUser", mapDispatch);
        List<Map<String, Object>> arrTargetList = this.selectRandomTarget(mapDispatch, query);
        JSONArray arrJson = new JSONArray();
        JSONObject json = null;
        if (arrTargetList.size() > 0) {
            String etc = String.valueOf(arrTargetList.get(0).get("ETC"));
            json = new JSONObject(etc);
            json.put("ID", arrTargetList.get(0).get("ID"));
            arrJson.put((Object)json);
        }
        JsonUtil.overWriteNullToEmpty(json);
        return arrJson;
    }

    private String makeCountSqlFromTargetSql(DBType type, String query, String count) {
        if (type == DBType.ORACLE) {
            return "SELECT * FROM (" + query + ") A WHERE ROWNUM <= " + count;
        }
        if (type == DBType.DB2) {
            return "SELECT * FROM ( " + query + " ) FETCH FIRST " + count + " ROWS ONLY";
        }
        if (type == DBType.MSSQL) {
            return "SELECT TOP " + count + " * FROM ( " + query + " ) A";
        }
        return "SELECT * FROM (" + query + ") A ORDER BY RAND() LIMIT " + count;
    }

    public List<Map<String, Object>> selectRandomTarget(HashMap<String, Object> mapDispatch, String query) throws Exception {
        ArrayList listTarget = new ArrayList();
        DriverManagerDataSource datasource = new DriverManagerDataSource();
        String drv = "";
        String url = "";
        String user = "";
        String pass = "";
        if (ObjectUtils.isEmpty((Object)mapDispatch.get("DB_URL")) || query.indexOf("TMS_TARGET_TEMP") >= 0) {
            drv = this.dataSourceProperties.getDriverClassName();
            url = this.dataSourceProperties.getUrl();
            user = this.dataSourceProperties.getUsername();
            pass = this.dataSourceProperties.getPassword();
        } else {
            try {
                drv = String.valueOf(mapDispatch.get("DB_DRV"));
                url = String.valueOf(mapDispatch.get("DB_URL"));
                user = String.valueOf(mapDispatch.get("DB_USR"));
                pass = HumusonDecryptor.decrypt((String)mapDispatch.get("DB_PWD").toString(), (String)this.tmsConfig.getHumusonKey());
            }
            catch (Exception e) {
                log.error("failed create datasource driver[{}], url[{}], user[{}] sql[{}] ", new Object[]{drv, url, user, query, e});
                throw e;
            }
        }
        try {
            datasource.setDriverClassName(drv);
            datasource.setUrl(url);
            datasource.setUsername(user);
            datasource.setPassword(pass);
            JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)datasource);
            List list = jdbcTemplate.queryForList(query);
            return list;
        }
        catch (Exception e) {
            log.error("query[{}] \n mapper query error driver[{}], url[{}], user[{}]", new Object[]{query, drv, url, user, e});
            throw e;
        }
        finally {
            if (!datasource.getConnection().isClosed()) {
                datasource.getConnection().close();
            }
        }
    }

    public JSONArray insertRandomTarget(HashMap<String, Object> mapDispatch, List<Map<String, Object>> listTarget) throws Exception {
        JSONArray arrTargets = new JSONArray();
        String object = null;
        JSONObject json = null;
        for (int i = 0; i < listTarget.size(); ++i) {
            TmsTargetTemp target = (TmsTargetTemp)TransObjectUtil.mapToBean(TmsTargetTemp.class, listTarget.get(i));
            target.setTMS_ETC(JsonUtil.convertMapToJsonString(listTarget.get(i)));
            target.setSEND_ID(Long.valueOf(String.valueOf(mapDispatch.get("SEND_ID"))));
            target.setTARGET_ID(Long.valueOf(String.valueOf(mapDispatch.get("TARGET_ID"))));
            target.setWORKDAY(DateUtil.getWorkday());
            target.setDATA01("REST_API");
            this.apiRandomSamplingDao.registRandomUser(target);
            target.setTMS_ETC("");
            object = new Gson().toJson((Object)target);
            json = new JSONObject(object);
            arrTargets.put((Object)json);
        }
        return arrTargets;
    }

    public static void main(String[] args) {
        DriverManagerDataSource datasource = new DriverManagerDataSource();
        String drv = "oracle.jdbc.driver.OracleDriver";
        String url = "jdbc:oracle:thin:@211.48.18.52:1521/orcl";
        String user = "tms";
        String pass = "humuson123!";
        datasource.setDriverClassName(drv);
        datasource.setUrl(url);
        datasource.setUsername(user);
        datasource.setPassword(pass);
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)datasource);
        jdbcTemplate.queryForList("SELECT * FROM DUAL");
    }
}

