/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.rest;

import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.rest.ExtractUserByDB;
import com.humuson.tms.trans.module.rest.ExtractUserByFile;
import com.humuson.tms.trans.repository.dao.CommonSendInfoDao;
import com.humuson.tms.trans.util.StringUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"defaultDatabaseConfig"})
public class ExtractRandomSampling {
    private static final Logger log = LoggerFactory.getLogger(ExtractRandomSampling.class);
    @Autowired
    CommonSendInfoDao commonSendInfoDao;
    @Autowired
    ExtractUserByDB extractUserByDB;
    @Autowired
    ExtractUserByFile extractUserByFile;
    String count = "5";

    public JSONObject getList(String sendId, String contentSendId, String count) throws Exception {
        this.count = count;
        HashMap<String, Object> mapDispatch = this.selectCommonInfo(sendId, contentSendId);
        JSONArray arrRandomTarget = null;
        if (Constants.TargetType.DB.name().equalsIgnoreCase(String.valueOf(mapDispatch.get("TARGET_TYPE"))) || Constants.TargetType.REL.name().equalsIgnoreCase(String.valueOf(mapDispatch.get("TARGET_TYPE"))) || Constants.TargetType.COND.name().equalsIgnoreCase(String.valueOf(mapDispatch.get("TARGET_TYPE")))) {
            arrRandomTarget = this.extractUserByDB.getRandomTarget(mapDispatch, count);
        } else if (Constants.TargetType.FILE.name().equalsIgnoreCase(String.valueOf(mapDispatch.get("TARGET_TYPE")))) {
            arrRandomTarget = this.extractUserByFile.getRandomTarget(mapDispatch, count);
        }
        return this.replayResult(mapDispatch, arrRandomTarget, false);
    }

    public JSONObject getUser(String sendId, String memberId, String contentSendId, String seq) throws Exception {
        HashMap<String, Object> mapDispatch = this.selectCommonInfo(sendId, contentSendId);
        JSONArray arrRandomTarget = null;
        arrRandomTarget = Constants.TargetType.FILE.name().equalsIgnoreCase(String.valueOf(mapDispatch.get("TARGET_TYPE"))) ? this.extractUserByFile.getSampleTarget(mapDispatch, memberId, seq) : this.extractUserByDB.getSampleTarget(mapDispatch, memberId, seq);
        return this.replayResult(mapDispatch, arrRandomTarget, true);
    }

    public HashMap<String, Object> selectCommonInfo(String sendId, String contentSendId) throws Exception {
        HashMap<String, Object> mapDispatch = this.commonSendInfoDao.selectTargetInfoBySendId(sendId);
        HashMap<String, Object> mapInfo = null;
        mapInfo = this.commonSendInfoDao.selectChannelInfo(String.valueOf(mapDispatch.get("CHANNEL_ID")));
        if (mapInfo != null && mapInfo.size() > 0) {
            mapDispatch.putAll(mapInfo);
        }
        if (StringUtil.isValidate(contentSendId)) {
            mapInfo = this.commonSendInfoDao.selectContentInfoBySendId(contentSendId);
            if (mapInfo != null && mapInfo.size() > 0) {
                mapDispatch.putAll(mapInfo);
            }
        } else {
            Object o = mapDispatch.get("CONTENT_ID");
            int contentId = -1;
            if (o != null) {
                if (o instanceof BigDecimal) {
                    BigDecimal number = (BigDecimal)o;
                    contentId = number.intValue();
                } else {
                    contentId = (Integer)o;
                }
            }
            if ((mapInfo = this.commonSendInfoDao.selectContentInfo(contentId)) != null && mapInfo.size() > 0) {
                mapDispatch.putAll(mapInfo);
            }
        }
        if ((mapInfo = this.getTargetInfo(mapDispatch)) != null && mapInfo.size() > 0) {
            mapDispatch.putAll(mapInfo);
        }
        return mapDispatch;
    }

    public JSONObject replayResult(HashMap<String, Object> mapDispatch, JSONArray arrRandomTarget, boolean isSingle) throws Exception {
        mapDispatch.remove("DB_PWD");
        mapDispatch.remove("DB_CHARSET_BASE");
        mapDispatch.remove("DB_USR");
        mapDispatch.remove("DB_DRV");
        if (mapDispatch.containsKey("DB_URL")) {
            mapDispatch.remove("DB_URL");
        }
        mapDispatch.remove("TARGET_QUERY_S");
        mapDispatch.remove("TARGET_QUERY_U");
        mapDispatch.remove("TARGET_WEB_COUNT");
        JSONObject object = new JSONObject(mapDispatch);
        object.put("TARGETS", (Object)arrRandomTarget);
        return object;
    }

    public HashMap<String, Object> getTargetInfo(HashMap<String, Object> schedule) throws Exception {
        if (Constants.TargetType.DB.name().equalsIgnoreCase(String.valueOf(schedule.get("TARGET_TYPE"))) || Constants.TargetType.REL.name().equalsIgnoreCase(String.valueOf(schedule.get("TARGET_TYPE"))) || Constants.TargetType.COND.name().equalsIgnoreCase(String.valueOf(schedule.get("TARGET_TYPE")))) {
            schedule.put("TARGET_QUERY_U", "");
            List<HashMap<String, Object>> mapTargetInfo = this.commonSendInfoDao.selectTargetQueryInfo(String.valueOf(schedule.get("TARGET_ID")));
            for (HashMap<String, Object> target : mapTargetInfo) {
                if ("10".equals(String.valueOf(target.get("QUERY_TYPE")))) {
                    schedule.put("TARGET_QUERY_S", String.valueOf(target.get("QUERY")));
                    schedule.put("TARGET_DB_ID", String.valueOf(target.get("DB_ID")));
                    schedule.put("DB_URL", String.valueOf(target.get("DB_URL")));
                    schedule.put("DB_DRV", String.valueOf(target.get("DB_DRV")));
                    schedule.put("DB_USR", String.valueOf(target.get("DB_USR")));
                    schedule.put("DB_PWD", String.valueOf(target.get("DB_PWD")));
                    schedule.put("DB_CHARSET_BASE", String.valueOf(target.get("DB_CHARSET_BASE")));
                    schedule.put("ENCRYPT_YN", String.valueOf(target.get("ENCRYPT_YN")));
                    continue;
                }
                if (!"40".equals(String.valueOf(target.get("QUERY_TYPE")))) continue;
                schedule.put("TARGET_QUERY_U", String.valueOf(target.get("QUERY")));
            }
        } else if (Constants.TargetType.FILE.name().equalsIgnoreCase(String.valueOf(schedule.get("TARGET_TYPE")))) {
            List<HashMap<String, Object>> mapTargetInfo = this.commonSendInfoDao.selectTargetFileInfo(String.valueOf(schedule.get("TARGET_ID")));
            schedule.put("TARGET_ID", String.valueOf(mapTargetInfo.get(0).get("TARGET_ID")));
            schedule.put("MAPPING_HEADER", String.valueOf(mapTargetInfo.get(0).get("MAPPING_HEADER")));
            schedule.put("FILE_ID", String.valueOf(mapTargetInfo.get(0).get("FILE_ID")));
            schedule.put("TARGET_FILE_ENCODING", String.valueOf(mapTargetInfo.get(0).get("TARGET_FILE_ENCODING")));
            schedule.put("TARGET_FILE_HEAD_FLAG", String.valueOf(mapTargetInfo.get(0).get("TARGET_FILE_HEAD_FLAG")));
            schedule.put("TARGET_FILE_DELIM", String.valueOf(mapTargetInfo.get(0).get("TARGET_FILE_DELIM")));
            schedule.put("TARGET_FILE_IDX", String.valueOf(mapTargetInfo.get(0).get("TARGET_FILE_IDX")));
            schedule.put("TARGET_FILE_NAME", String.valueOf(mapTargetInfo.get(0).get("TARGET_FILE_NAME")));
            schedule.put("ENCRYPT_YN", String.valueOf(mapTargetInfo.get(0).get("ENCRYPT_YN")));
        }
        return schedule;
    }
}

