/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.realtime;

import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.CheckerPossible;
import com.humuson.tms.trans.module.realtime.DuplicationSchdTargetException;
import com.humuson.tms.trans.module.realtime.RealtimeBasicScheduleTarget;
import com.humuson.tms.trans.module.realtime.RealtimeFileScheduleTarget;
import com.humuson.tms.trans.module.realtime.RealtimeScheduleTarget;
import com.humuson.tms.trans.repository.dao.RealtimeDao;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.trans.util.ObjectUtil;
import com.humuson.tms.util.date.DateUtil;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class RealtimeScheduleFactory {
    private static final Logger log = LoggerFactory.getLogger(RealtimeScheduleFactory.class);
    private String failMessage;
    @Autowired
    private RealtimeDao realtimeDao;
    @Value(value="${tms.tracking.close.day:7}")
    private int tracking_close;

    public boolean createScheduler(TmsSendInfo tmsSendInfo, CheckerPossible<TmsSendInfo> checkerSchedulerForRegist) {
        if (!this.isPassableCheck(tmsSendInfo, checkerSchedulerForRegist)) {
            this.failMessage = checkerSchedulerForRegist.impassableMessage();
            return false;
        }
        return this.createRealtimeScheduler(tmsSendInfo);
    }

    private boolean isPassableCheck(TmsSendInfo tmsSendInfo, CheckerPossible checkerSchedulerForRegist) {
        return checkerSchedulerForRegist.passableRegist(tmsSendInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED)
    private boolean createRealtimeScheduler(TmsSendInfo tmsSendInfo) {
        TmsSchdInfo tmsSchdInfo = new TmsSchdInfo();
        String resultJobstatus = "30";
        try {
            ObjectUtil.objectMerge(tmsSchdInfo, tmsSendInfo);
            this.setAddField(tmsSchdInfo);
            this.insertRealtimeSchedule(tmsSendInfo, tmsSchdInfo);
        }
        catch (DuplicationSchdTargetException e1) {
            log.error("DS0137|real-time attempt creating schd_info/target table but already exists schd_info[{}]", (Object)tmsSchdInfo, (Object)e1);
            resultJobstatus = "31";
        }
        catch (Exception e) {
            log.error("DS0138| error creating real-time schd_info[{}]", (Object)tmsSchdInfo, (Object)e);
            resultJobstatus = "31";
        }
        finally {
            this.finishUpdateJobStatus(tmsSendInfo, tmsSchdInfo, resultJobstatus);
        }
        return "30".equals(resultJobstatus);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    private void insertRealtimeSchedule(TmsSendInfo tmsSendInfo, TmsSchdInfo tmsSchdInfo) throws SQLException, Exception {
        this.realtimeDao.insertTmsSchdInfo(tmsSchdInfo);
        RealtimeScheduleTarget realtimeScheduleTarget = this.getSchdTarget(tmsSendInfo.getTARGET_TYPE(), tmsSchdInfo);
        realtimeScheduleTarget.registTmsSchdTarget(tmsSchdInfo);
        log.info("created real-time scheduler[SEND_ID={}, SCHD_ID={}]", (Object)tmsSendInfo.getSEND_ID(), (Object)tmsSchdInfo.getSCHD_ID());
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    private void finishUpdateJobStatus(TmsSendInfo tmsSendInfo, TmsSchdInfo tmsSchdInfo, String resultJobstatus) {
        try {
            this.updateSendInfoJobStatus(tmsSendInfo, resultJobstatus);
            this.updateSchdInfoJobStatus(tmsSchdInfo, resultJobstatus);
        }
        catch (Exception e) {
            log.error("DS0134|failed finish update job status send info[id={}], schd info[id={}] ", new Object[]{tmsSendInfo.getSEND_ID(), tmsSchdInfo.getSCHD_ID(), e});
        }
    }

    private String ifPushChannelThenSetJobStatus15(String channelType) {
        return Constants.ChannelType.PU.name().equals(channelType) ? "15" : "10";
    }

    private void updateSchdInfoJobStatus(TmsSchdInfo tmsSchdInfo, String resultJobstatus) {
        if (!"31".equals(resultJobstatus)) {
            resultJobstatus = this.ifPushChannelThenSetJobStatus15(tmsSchdInfo.getCHANNEL_TYPE());
        }
        try {
            this.realtimeDao.updateSchdInfoJobStatus(tmsSchdInfo.getSCHD_ID(), resultJobstatus);
            log.info("real-time updated schd_id[{}] job_status[{} -> {}]", new Object[]{tmsSchdInfo.getSCHD_ID(), tmsSchdInfo.getJOB_STATUS(), resultJobstatus});
        }
        catch (Exception e) {
            log.error("DS0135| failed schd_id[{}] update JobStatus[{} -> {}] tmsSchdInfo[{}]", new Object[]{tmsSchdInfo.getSCHD_ID(), tmsSchdInfo.getJOB_STATUS(), resultJobstatus, tmsSchdInfo});
        }
    }

    private void updateSendInfoJobStatus(TmsSendInfo tmsSendInfo, String resultJobstatus) {
        try {
            this.realtimeDao.updateSendInfoJobStatus1(tmsSendInfo.getSEND_ID(), "15", resultJobstatus);
        }
        catch (Exception e) {
            log.error("DS0136| failed JobStatus tmsSendInfo[{}]", (Object)tmsSendInfo);
        }
    }

    private RealtimeScheduleTarget getSchdTarget(String targetType, TmsSchdInfo tmsSchdInfo) {
        return Constants.TargetType.FILE.name().equals(targetType) ? (RealtimeScheduleTarget)ClassDispatcher.getApplicationContext().getBean(RealtimeFileScheduleTarget.class) : (RealtimeScheduleTarget)ClassDispatcher.getApplicationContext().getBean(RealtimeBasicScheduleTarget.class);
    }

    private void setAddField(TmsSchdInfo tmsSchdInfo) {
        tmsSchdInfo.setWORKDAY(DateUtil.getWorkday());
        tmsSchdInfo.setEND_DATE(DateUtil.getDateEndTime());
        tmsSchdInfo.setJOB_STATUS("00");
        tmsSchdInfo.setDEL_YN("N");
        tmsSchdInfo.setWORKING_YN("N");
        tmsSchdInfo.setTRIGGER_METHOD(Constants.TriggerMethod.C5.name());
        tmsSchdInfo.setTRACKING_CLOSE(DateUtil.addDate((String)"yyyy-MM-dd", (int)this.tracking_close));
        tmsSchdInfo.setREQ_DATE(null);
        tmsSchdInfo.setGRP_ID("" + System.currentTimeMillis());
    }

    public String getFailMessage() {
        return this.failMessage;
    }
}

