/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.realtime;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.realtime.DuplicationSchdTargetException;
import com.humuson.tms.trans.module.realtime.NotExistUpdateQueryException;
import com.humuson.tms.trans.module.realtime.RealtimeScheduleTarget;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSchdTarget;
import com.humuson.tms.trans.repository.model.TmsTargetLinkQueryInfo;
import com.humuson.tms.trans.util.ObjectUtil;
import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RealtimeBasicScheduleTarget
extends RealtimeScheduleTarget {
    private static final Logger log = LoggerFactory.getLogger(RealtimeBasicScheduleTarget.class);
    @Autowired
    DefaultDatabaseConfig localDatabaseConfig;

    @Override
    TmsSchdTarget insertTmsSchdTarget(TmsSchdInfo tmsSchdInfo) throws Exception {
        TmsSchdTarget tmsSchdTarget = new TmsSchdTarget();
        boolean isExistUpdateSql = false;
        if (this.alreadyExists(tmsSchdInfo.getSCHD_ID(), tmsSchdInfo.getWORKDAY())) {
            throw new DuplicationSchdTargetException(tmsSchdInfo.getSCHD_ID());
        }
        try {
            List<TmsTargetLinkQueryInfo> tmsTargetLinkQueryInfos = this.targetInfoDao.selectTargetLinkQueryInfo(tmsSchdInfo.getTARGET_ID(), "DB");
            for (TmsTargetLinkQueryInfo tmsTargetLinkQueryInfo : tmsTargetLinkQueryInfos) {
                if ("10".equals(tmsTargetLinkQueryInfo.getQUERY_TYPE())) {
                    ObjectUtil.objectMerge(tmsSchdTarget, tmsSchdInfo, tmsTargetLinkQueryInfo);
                    if (this.isPushChannel(tmsSchdInfo.getCHANNEL_TYPE()) && !this.isMultiChannel(tmsSchdInfo.getSEND_ID())) {
                        tmsSchdTarget.setTARGET_DB_ID(-1);
                        tmsSchdTarget.setTARGET_QUERY_S(this.makeRealtimePushTargetQuery(this.localDatabaseConfig.getDbType()));
                        continue;
                    }
                    tmsSchdTarget.setTARGET_DB_ID(tmsTargetLinkQueryInfo.getDB_ID());
                    tmsSchdTarget.setTARGET_QUERY_S(tmsTargetLinkQueryInfo.getQUERY());
                    continue;
                }
                if (!"40".equals(tmsTargetLinkQueryInfo.getQUERY_TYPE())) continue;
                if (this.isPushChannel(tmsSchdInfo.getCHANNEL_TYPE()) && !this.isMultiChannel(tmsSchdInfo.getSEND_ID())) {
                    tmsSchdTarget.setTARGET_QUERY_U(this.makeRealtimePushUpdateQuery());
                }
                isExistUpdateSql = true;
            }
            tmsSchdTarget.setCT_TARGET_TYPE("DB");
            if (!isExistUpdateSql) {
                log.error("DS0126| it is not exist update query. so update job_status(41) tmsSchdInfo[{}] ", (Object)tmsSchdInfo.getSCHD_ID());
                this.schdInfoDao.updateSchdInfoJobStatus(tmsSchdInfo.getSCHD_ID(), "41");
                throw new NotExistUpdateQueryException("schd_id=" + tmsSchdInfo.getSCHD_ID());
            }
            if (this.schdInfoDao.insertTmsSchdTarget(tmsSchdTarget) != 1) {
                log.error("DS0127|don't inserted. count zero DB tmsSchdTarget[{}] ", (Object)tmsSchdTarget);
            }
            return tmsSchdTarget;
        }
        catch (Exception e) {
            log.error("DS0128| error inserting DB tmsSchdTarget[{}] ", (Object)tmsSchdTarget, (Object)e);
            throw e;
        }
    }

    private boolean alreadyExists(long schdId, String workday) {
        return false;
    }

    private String makeRealtimePushUpdateQuery() {
        return ((StringBuilder)new SQL(){
            {
                this.UPDATE("TMS_TARGET_TEMP");
                this.SET("TARGET_FLAG='Y'");
                this.WHERE("TARGET_TEMP_ID=#{TARGET_TEMP_ID} AND TARGET_FLAG='N'");
            }
        }.usingAppender((Appendable)new StringBuilder())).toString();
    }

    private String makeRealtimePushTargetQuery(DBType dbType) {
        if (DBType.ORACLE == dbType) {
            return ((StringBuilder)new SQL(){
                {
                    this.SELECT("DISTINCT T.TMS_M_ID,    T.TARGET_ID,   D.APP_GRP_ID,  D.APP_ID,      D.DEVICE_ID,   D.DEVICE,      D.NOTI_FLAG,   D.BMKT_FLAG,   D.UUID,        D.OS,          NVL(T.TMS_M_TOKEN, D.TOKEN) AS TMS_M_TOKEN,T.GRP_SEQ,     T.WORKDAY,     T.SEND_ID,     T.TMS_M_NAME,  T.TMS_M_EMAIL, T.TMS_M_PHONE, T.TARGET_FLAG, T.DATA01,      T.DATA02,      T.DATA03,      T.ETC,         T.REG_DATE     ");
                    this.FROM(" TMS_TARGET_TEMP T");
                    this.LEFT_OUTER_JOIN("TMS_APP_DEVICE_LIST D  on T.TMS_M_ID = D.CUST_ID");
                    this.INNER_JOIN("TMS_APP_USER_LIST U on  U.SITE_ID = D.SITE_ID  AND U.CUST_ID = D.CUST_ID  AND U.LAST_DEVICE_ID = D.DEVICE_ID");
                    this.WHERE(" T.TARGET_ID = #{TARGET_ID} ");
                    this.WHERE(" T.GRP_SEQ = #{GRP_SEQ} ");
                    this.WHERE(" T.SEND_ID= #{SEND_ID} ");
                    this.WHERE(" T.TARGET_FLAG = 'N' ");
                    this.WHERE(" T.WORKDAY = #{WORKDAY} ");
                    this.WHERE(" (D.APP_GRP_ID IS NOT NULL AND D.APP_GRP_ID = (SELECT APP_GRP_ID FROM TMS_ADDITION_INFO WHERE SEND_ADD_ID = (SELECT SEND_ADD_ID FROM TMS_SEND_INFO WHERE SEND_ID=#{SEND_ID} )))");
                }
            }.usingAppender((Appendable)new StringBuilder())).toString();
        }
        return ((StringBuilder)new SQL(){
            {
                this.SELECT("DISTINCT T.TMS_M_ID,    T.TARGET_ID,   D.APP_GRP_ID,  D.APP_ID,      D.DEVICE_ID,   D.DEVICE,      D.NOTI_FLAG,   D.BMKT_FLAG,   D.UUID,        D.OS,          IFNULL(T.TMS_M_TOKEN, D.TOKEN) AS TMS_M_TOKEN,T.GRP_SEQ,     T.WORKDAY,     T.SEND_ID,     T.TMS_M_NAME,  T.TMS_M_EMAIL, T.TMS_M_PHONE, T.TARGET_FLAG, T.DATA01,      T.DATA02,      T.DATA03,      T.ETC,         T.REG_DATE     ");
                this.FROM(" TMS_TARGET_TEMP T");
                this.LEFT_OUTER_JOIN("TMS_APP_DEVICE_LIST D  on T.TMS_M_ID = D.CUST_ID");
                this.INNER_JOIN("TMS_APP_USER_LIST U on  U.SITE_ID = D.SITE_ID  AND U.CUST_ID = D.CUST_ID  AND U.LAST_DEVICE_ID = D.DEVICE_ID");
                this.WHERE(" T.TARGET_ID = #{TARGET_ID} ");
                this.WHERE(" T.GRP_SEQ = #{GRP_SEQ} ");
                this.WHERE(" T.SEND_ID= #{SEND_ID} ");
                this.WHERE(" T.TARGET_FLAG = 'N' ");
                this.WHERE(" T.WORKDAY = #{WORKDAY} ");
                this.WHERE(" (D.APP_GRP_ID IS NOT NULL AND D.APP_GRP_ID = (SELECT APP_GRP_ID FROM TMS_ADDITION_INFO WHERE SEND_ADD_ID = (SELECT SEND_ADD_ID FROM TMS_SEND_INFO WHERE SEND_ID=#{SEND_ID} )))");
            }
        }.usingAppender((Appendable)new StringBuilder())).toString();
    }

    private boolean isPushChannel(String channelType) {
        return Constants.ChannelType.PU.name().equalsIgnoreCase(channelType);
    }
}

