/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.realtime;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.CheckerPossibleOfChain;
import com.humuson.tms.trans.module.query.TestQueryAssembly;
import com.humuson.tms.trans.repository.dao.RealtimeDao;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
@Qualifier(value="CheckerQuerySentenceInRealtime")
public class CheckerQuerySentenceInRealtime
extends CheckerPossibleOfChain<TmsSendInfo> {
    private static final Logger log = LoggerFactory.getLogger(CheckerQuerySentenceInRealtime.class);
    private String impassableMessage = "This query is not executed.";
    private String notCloseMessage = null;
    @Autowired
    RealtimeDao realtimeDao;
    @Autowired
    protected TestQueryAssembly testQueryAssembly;
    @Autowired
    private TmsJdbcTemplate tmsJdbcTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isPassableRegist(TmsSendInfo sendInfo) {
        targetLinkQueryInfo = null;
        try {
            targetLinkQueryInfo = this.realtimeDao.selectOneTargetLinkQueryInfo(sendInfo.getTARGET_ID(), "10");
        }
        catch (TooManyResultsException e) {
            this.impassableMessage = "This target_id[{}] too many query_type[10]" + sendInfo.getTARGET_ID();
            this.errorUpdateJobstatus(sendInfo);
            return false;
        }
        catch (Exception e) {
            this.impassableMessage = "This target_id[" + sendInfo.getTARGET_ID() + "] failed. selecting TargetLinkQueryInfo query_type[10] error msg=" + e.getMessage();
            CheckerQuerySentenceInRealtime.log.error("DS0122|select error xml_id=selectOneTargetLinkQueryInfo(target_id={}, query_type=10)", (Object)sendInfo.getTARGET_ID(), (Object)e);
            this.errorUpdateJobstatus(sendInfo);
            return false;
        }
        queryOptimizer = null;
        if (Constants.TargetType.FILE.name().equals(targetLinkQueryInfo.getTARGET_TYPE())) {
            var4_6 = true;
            return var4_6;
        }
        ** try [egrp 4[TRYBLOCK] [16 : 224->318)] { 
lbl-1000:
        // 2 sources

        {
            catch (Exception e) {
                this.impassableMessage = "db_id[" + targetLinkQueryInfo.getDB_ID() + "] connect error";
                CheckerQuerySentenceInRealtime.log.error("DS0124| fail tmsJdbcTemplate setting db_id[{}]", (Object)targetLinkQueryInfo.getDB_ID(), (Object)e);
                var5_12 = false;
                return var5_12;
            }
        }
        {
        }
lbl-1000:
        // 1 sources

        {
            queryOptimizer = this.testQueryAssembly.getQueryOptimizer(targetLinkQueryInfo.getDB_TYPE());
            queryOptimizer.setDbId(targetLinkQueryInfo.getDB_ID());
            limitOneSelectQuery = queryOptimizer.makeOnlyOneSql(targetLinkQueryInfo.getQUERY());
            this.tmsJdbcTemplate.db(targetLinkQueryInfo.getDB_ID());
            try {
                this.tmsJdbcTemplate.selectOne(limitOneSelectQuery);
                if (CheckerQuerySentenceInRealtime.log.isDebugEnabled()) {
                    CheckerQuerySentenceInRealtime.log.debug("this query normal from TargetLinkInfo.target_linke_id[{}]", (Object)targetLinkQueryInfo.getTARGET_LINK_ID());
                }
                e2 = true;
            }
            catch (Exception e) {}
            {
                CheckerQuerySentenceInRealtime.log.error("DS0123|This query is not executed. send_id[{}] target_link_id[{}] SQL={}", new Object[]{sendInfo.getSEND_ID(), targetLinkQueryInfo.getTARGET_LINK_ID(), limitOneSelectQuery, e});
                this.impassableMessage = "This query is not executed. target_link_id=" + targetLinkQueryInfo.getTARGET_LINK_ID() + " SQL=" + limitOneSelectQuery;
                this.errorUpdateJobstatus(sendInfo);
                e2 = false;
            }
            try {
                this.tmsJdbcTemplate.close();
                return e2;
            }
            catch (Exception e2) {
                this.notCloseMessage = " db_id[" + targetLinkQueryInfo.getDB_ID() + "] close error from connection";
                return e2;
            }
            finally {
                if (queryOptimizer != null) {
                    queryOptimizer.close();
                }
            }
            try {
                this.tmsJdbcTemplate.close();
                return e2;
            }
            catch (Exception e2) {
                this.notCloseMessage = " db_id[" + targetLinkQueryInfo.getDB_ID() + "] close error from connection";
                return e2;
            }
            finally {
                if (queryOptimizer != null) {
                    queryOptimizer.close();
                }
            }
        }
        finally {
            try {
                this.tmsJdbcTemplate.close();
            }
            catch (Exception e2) {
                this.notCloseMessage = " db_id[" + targetLinkQueryInfo.getDB_ID() + "] close error from connection";
            }
            finally {
                if (queryOptimizer != null) {
                    queryOptimizer.close();
                }
            }
        }
    }

    private void errorUpdateJobstatus(TmsSendInfo sendInfo) {
        try {
            this.realtimeDao.updateSendInfoJobStatus(sendInfo.getSEND_ID(), "31");
        }
        catch (Exception e2) {
            log.error("DS0125| error send info[{}] job status=41 in real time query validate failed", (Object)sendInfo.getSEND_ID(), (Object)e2);
        }
    }

    @Override
    protected String getImpassableMessage() {
        return this.impassableMessage + (this.notCloseMessage != null ? this.notCloseMessage : "");
    }
}

