/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.realtime;

import com.humuson.tms.trans.module.CheckerPossibleOfChain;
import com.humuson.tms.trans.repository.dao.RealtimeDao;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Scope(value="prototype")
@Component
@Qualifier(value="CheckerExistUpdateQuery")
public class CheckerExistUpdateQuery
extends CheckerPossibleOfChain<TmsSendInfo> {
    private static final Logger log = LoggerFactory.getLogger(CheckerExistUpdateQuery.class);
    private String impassableMessage = "This query is not executed.";
    private String notCloseMessage = null;
    final RealtimeDao realtimeDao;

    @Override
    protected boolean isPassableRegist(TmsSendInfo sendInfo) {
        try {
            if (this.isUpdateQueryEmpty(sendInfo.getTARGET_ID())) {
                this.impassableMessage = String.format("This target_id[{}] is not exist update query[40]", sendInfo.getTARGET_ID());
                this.errorUpdateJobstatus(sendInfo);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.impassableMessage = String.format("This target_id[{}] is not exist update query check error [40]", sendInfo.getTARGET_ID());
            this.errorUpdateJobstatus(sendInfo);
            return false;
        }
    }

    private boolean isUpdateQueryEmpty(long targetId) {
        return ObjectUtils.isEmpty(this.realtimeDao.selectTargetLinkUpdateQueryInfo(targetId, "40"));
    }

    private void errorUpdateJobstatus(TmsSendInfo sendInfo) {
        try {
            this.realtimeDao.updateSendInfoJobStatus(sendInfo.getSEND_ID(), "31");
        }
        catch (Exception e2) {
            log.error("DS0121| error send info[{}] job status=41 in real time query validate failed", (Object)sendInfo.getSEND_ID(), (Object)e2);
        }
    }

    @Override
    protected String getImpassableMessage() {
        return this.impassableMessage + (this.notCloseMessage != null ? this.notCloseMessage : "");
    }

    public CheckerExistUpdateQuery(RealtimeDao realtimeDao) {
        this.realtimeDao = realtimeDao;
    }
}

