/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.realtime;

import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.CheckerPossibleOfChain;
import com.humuson.tms.trans.repository.dao.RealtimeDao;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.util.date.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Scope(value="prototype")
@Component
@Qualifier(value="CheckerDuplicationForRegist")
public class CheckerDuplicationForRegist
extends CheckerPossibleOfChain<TmsSendInfo> {
    private static final Logger log = LoggerFactory.getLogger(CheckerDuplicationForRegist.class);
    @Autowired
    RealtimeDao realtimeDao;
    protected TmsSchdInfo tmsSchdInfo = null;
    public static final String IMPASSABLE_MSG = "is existed(duplicate) comfirm schd_info.schd_id = ";

    public void initial() {
        this.tmsSchdInfo = null;
    }

    @Override
    protected boolean isPassableRegist(TmsSendInfo tmsSendInfo) {
        try {
            this.initial();
            this.tmsSchdInfo = this.realtimeDao.selectTmsSchdInfoForExist(tmsSendInfo.getSEND_ID(), DateUtil.getWorkday(), Constants.TriggerMethod.C5.name());
            return ObjectUtils.isEmpty((Object)this.tmsSchdInfo);
        }
        catch (Exception e) {
            log.error("DS0120|failed checking real time duplication send info[id={}] ", (Object)tmsSendInfo.getSEND_ID(), (Object)e);
            return false;
        }
    }

    @Override
    protected String getImpassableMessage() {
        if (!ObjectUtils.isEmpty((Object)this.tmsSchdInfo)) {
            StringBuilder sb = new StringBuilder();
            sb.append("SCHD_ID:").append(this.tmsSchdInfo.getSCHD_ID());
            return IMPASSABLE_MSG + sb.toString();
        }
        if (ObjectUtils.isEmpty((Object)this.tmsSchdInfo)) {
            return "is existed(duplicate) comfirm schd_info.schd_id = not found";
        }
        return IMPASSABLE_MSG + this.tmsSchdInfo.getSCHD_ID();
    }
}

