/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.realtime;

import com.humuson.tms.trans.module.CheckerPossibleOfChain;
import com.humuson.tms.trans.repository.dao.RealtimeDao;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Transactional
@Scope(value="prototype")
@Component
@Qualifier(value="CheckerDoingWorkOfYesterday")
public class CheckerDoingWorkOfYesterday
extends CheckerPossibleOfChain<TmsSendInfo> {
    private static final Logger log = LoggerFactory.getLogger(CheckerDoingWorkOfYesterday.class);
    @Autowired
    RealtimeDao realtimeDao;
    long sendId;
    public static final String IMPASSABLE_MSG = "old exist schd_info is working or etc (job_status != 15) send_id=";

    @Override
    protected boolean isPassableRegist(TmsSendInfo tmsSendInfo) {
        try {
            this.sendId = tmsSendInfo.getSEND_ID();
            int schdIdCount = this.realtimeDao.updateStatusOfOldExistSchd(tmsSendInfo.getSEND_ID(), "40");
            if (schdIdCount == 0) {
                TmsSchdInfo tmsSchdInfo = this.realtimeDao.selectMaxSchdInfoOfC5(tmsSendInfo.getSEND_ID(), "");
                if (ObjectUtils.isEmpty((Object)tmsSchdInfo)) {
                    log.info("not found real-time schd-info of send_id[{}] so create real-time schd-info", (Object)tmsSendInfo.getSEND_ID());
                    return true;
                }
                if ("40".equals(tmsSchdInfo.getJOB_STATUS()) || "41".equals(tmsSchdInfo.getJOB_STATUS()) || "43".equals(tmsSchdInfo.getJOB_STATUS())) {
                    log.info("last schd-info workday[{}] job-status[{}] create real-time schd-info", (Object)tmsSchdInfo.getWORKDAY(), (Object)tmsSchdInfo.getJOB_STATUS());
                    return true;
                }
            }
            log.info("real-time old exist schd_info.job_status=40 update send_id={} count={}", (Object)tmsSendInfo.getSEND_ID(), (Object)schdIdCount);
            return schdIdCount != 0;
        }
        catch (Exception e) {
            log.error("DS0119|failed update job status of old exist schdInfo send_id={}] ", (Object)tmsSendInfo.getSEND_ID(), (Object)e);
            return false;
        }
    }

    @Override
    protected String getImpassableMessage() {
        return IMPASSABLE_MSG + this.sendId;
    }
}

