/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.realtime;

import com.humuson.tms.trans.module.CheckerPossibleOfChain;
import com.humuson.tms.trans.repository.dao.RealtimeDao;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
@Qualifier(value="CheckerDeletedInSiteAndCamp")
public class CheckerDeletedInSiteAndCamp
extends CheckerPossibleOfChain<TmsSendInfo> {
    private static final Logger log = LoggerFactory.getLogger(CheckerDeletedInSiteAndCamp.class);
    public static final String DELETE_N = "N";
    public static final String IMPASSABLE_MSG = "deleted in site or camp message check del_yn";
    @Autowired
    RealtimeDao realtimeDao;

    @Override
    protected boolean isPassableRegist(TmsSendInfo tmsSendInfo) {
        try {
            boolean isPassable;
            boolean bl = isPassable = DELETE_N.equals(tmsSendInfo.getSITE_DEL_YN().trim()) && DELETE_N.equals(tmsSendInfo.getCAMP_DEL_YN().trim());
            if (!isPassable) {
                log.warn("tms sendid[{}] site_delete[{}] camp_delete[{}]", new Object[]{tmsSendInfo.getSEND_ID(), tmsSendInfo.getSITE_DEL_YN(), tmsSendInfo.getCAMP_DEL_YN()});
                this.realtimeDao.updateSendInfoJobStatus(tmsSendInfo.getSEND_ID(), "31");
            }
            return isPassable;
        }
        catch (Exception e) {
            log.error("DS0118|fail checking delete in site or camp send info[id={}]", (Object)tmsSendInfo.getSEND_ID(), (Object)e);
            return false;
        }
    }

    @Override
    protected String getImpassableMessage() {
        return IMPASSABLE_MSG;
    }
}

