/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.realtime;

import com.humuson.tms.trans.module.realtime.CheckerDuplicationForRegist;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Transactional
@Scope(value="prototype")
@Component
@Qualifier(value="CheckerChangedScheduler")
public class CheckerChangedScheduler
extends CheckerDuplicationForRegist {
    private static final Logger log = LoggerFactory.getLogger(CheckerChangedScheduler.class);
    private String impassableMessage = "is existed schd info comfirm schd_id = ";

    @Override
    public boolean isPassableRegist(TmsSendInfo tmsSendInfo) {
        try {
            boolean isExisted;
            boolean bl = isExisted = !super.isPassableRegist(tmsSendInfo);
            if (!isExisted) {
                if (this.isDateChanged(tmsSendInfo.getSEND_ID())) {
                    this.updateJobstatusOfSchdInfoDuplicated("40");
                }
                return true;
            }
            if (isExisted && this.schdStopStatus()) {
                log.info("this real time send_info[{}] re starting so creating new schd-info. \n past schd-info[id={} jobstatus={}] stoped", new Object[]{tmsSendInfo.getSEND_ID(), this.tmsSchdInfo.getSCHD_ID(), this.tmsSchdInfo.getJOB_STATUS()});
                return true;
            }
            if (isExisted && this.isChanged(tmsSendInfo)) {
                this.updateJobstatusOfSchdInfoDuplicated("41");
                return true;
            }
            this.impassableMessage = "is existed schd info comfirm schd_id = " + this.tmsSchdInfo.getSCHD_ID();
            return false;
        }
        catch (Exception e) {
            log.error("DS0116|fail checking changed real time scheduler send info[id={}] ", (Object)tmsSendInfo.getSEND_ID(), (Object)e);
            return false;
        }
    }

    private boolean schdStopStatus() {
        return "43".equals(this.tmsSchdInfo.getJOB_STATUS()) || "42".equals(this.tmsSchdInfo.getJOB_STATUS()) || "41".equals(this.tmsSchdInfo.getJOB_STATUS()) || "40".equals(this.tmsSchdInfo.getJOB_STATUS());
    }

    private boolean isDateChanged(long sendId) {
        return !ObjectUtils.isEmpty(this.realtimeDao.selectSchdInfos(sendId, "C5"));
    }

    protected boolean isChanged(TmsSendInfo tmsSendInfo) {
        return !this.isSame(tmsSendInfo, this.tmsSchdInfo);
    }

    private boolean isSame(TmsSendInfo t, TmsSchdInfo s) {
        return t.getTARGET_ID() == s.getTARGET_ID() && t.getTRIGGER_ID() == s.getTRIGGER_ID() && t.getCONTENT_ID() == s.getCONTENT_ID() && t.getSITE_ID() == s.getSITE_ID() && t.getCHANNEL_ID() == s.getCHANNEL_ID() && t.getCAMP_ID().equals(s.getCAMP_ID());
    }

    private void ifNotUsedThenUpdateJobstatusInSchdInfo() {
        if (this.ifNotUse()) {
            this.impassableMessage = "schd info[schd_id=" + this.tmsSchdInfo.getSCHD_ID() + "] is not use. so change job_status=" + this.tmsSchdInfo.getJOB_STATUS() + "-> 10";
            this.realtimeDao.updateSchdInfoJobStatus(this.tmsSchdInfo.getSCHD_ID(), "10");
            log.info("[realtime-C5] changed to schdInfo[schd_id={}] so update other job_status=41", (Object)this.tmsSchdInfo.getSCHD_ID());
        }
    }

    private void updateJobstatusOfSchdInfoDuplicated(String _JOB_STATUS) {
        try {
            if (this.tmsSchdInfo == null) {
                return;
            }
            if ("10".equals(this.tmsSchdInfo.getJOB_STATUS()) || "15".equals(this.tmsSchdInfo.getJOB_STATUS()) || "42".equals(this.tmsSchdInfo.getJOB_STATUS()) || "40".equals(this.tmsSchdInfo.getJOB_STATUS())) {
                this.realtimeDao.updateSchdInfoJobStatus(this.tmsSchdInfo.getSCHD_ID(), _JOB_STATUS);
                log.warn("is duplicate TMS_SCHD_INFO[new-SCHD_ID[{}] / old-SCHD_ID={}]. so update old schd_id.job_status='41'", (Object)this.tmsSchdInfo.getSCHD_ID(), (Object)this.tmsSchdInfo.getSCHD_ID());
            }
        }
        catch (Exception e) {
            log.error("DS0117|error update(41) duplicate TMS_SCHD_INFO[{}]", (Object)this.tmsSchdInfo, (Object)e);
        }
    }

    private boolean ifNotUse() {
        return !"10".equals(this.tmsSchdInfo.getJOB_STATUS());
    }

    @Override
    protected String getImpassableMessage() {
        return this.impassableMessage;
    }
}

