/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.queue;

import com.humuson.tms.trans.module.TmsBatchTargetInfoFactory;
import com.humuson.tms.trans.module.batch.TmsBatchDbTargetExecutor;
import com.humuson.tms.trans.module.batch.TmsBatchTargetInfo;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.util.json.JsonConvertUtil;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RealtimeTargetListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RealtimeTargetListener.class);
    @Autowired
    TmsBatchTargetInfoFactory batchTargetInfoFactory;
    @Autowired
    TmsBatchDbTargetExecutor executor;

    public void onMessage(Message message) {
        try {
            TmsSendInfo tmsSendInfo = this.getSendInfoFromMessage(message);
            if (log.isInfoEnabled()) {
                log.info("realtime receive send_id[{}] from mq", (Object)tmsSendInfo.getSEND_ID());
            }
            TmsBatchTargetInfo tmsBatchTargetInfo = this.batchTargetInfoFactory.createBatchTargetInfo(tmsSendInfo, false);
            this.batchTargetInfoFactory.setSchdIfRealtime(tmsBatchTargetInfo);
            this.executor.execute(tmsBatchTargetInfo);
            if (!tmsBatchTargetInfo.isNOW_TARGETING()) {
                throw new RuntimeException();
            }
        }
        catch (JMSException e) {
            log.error("realtime push error receive from MQ, message=[{}]", (Object)((TextMessage)message), (Object)e);
        }
        catch (Exception e) {
            log.error("realtime push batch process error message=[{}]", (Object)((TextMessage)message), (Object)e);
        }
    }

    protected String convertStringMessage(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            return textMessage.getText();
        }
        log.error("received realtime push messge from MQ is not text. message={}", (Object)message);
        throw new JMSException("1000");
    }

    private TmsSendInfo getSendInfoFromMessage(Message message) throws Exception {
        return (TmsSendInfo)JsonConvertUtil.jsonStringToObject((String)this.convertStringMessage(message), TmsSendInfo.class);
    }
}

