/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.queue;

import com.humuson.tms.adaptor.activemq.ActivemqConnectorConfig;
import com.humuson.tms.trans.module.queue.RealtimeTargetListener;
import com.humuson.tms.trans.module.queue.TmsMessageListenerFactory;
import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableJms
@Configuration
@ConditionalOnClass(value={ActivemqConnectorConfig.class})
public class ActivemqConnectorEnviroment {
    @Value(value="${spring.jms.listener.concurrency}")
    private String concurrency;
    @Value(value="#{new Integer('${spring.jms.executor.initSize:10}')}")
    private String initSize;
    @Value(value="#{new Integer('${spring.jms.executor.maxSize:10}')}")
    private String maxSize;
    @Value(value="#{new Integer('${spring.jms.executor.capacity:10}')}")
    private String capacity;
    @Value(value="${spring.activemq.queue.consumer}")
    private String consumerName;
    private final RealtimeTargetListener realtimePushTargetListener;

    @Bean
    public TmsMessageListenerFactory initListenerContainer(ConnectionFactory connectionFactory) {
        String[] destinationNames;
        TmsMessageListenerFactory tmsChannelFactory = TmsMessageListenerFactory.listenerManager;
        for (String destination : destinationNames = this.consumerName.split(",")) {
            DefaultMessageListenerContainer channelHandlerListener = new DefaultMessageListenerContainer();
            channelHandlerListener.setConnectionFactory(connectionFactory);
            channelHandlerListener.setDestinationName(destination);
            channelHandlerListener.setMessageListener((Object)this.realtimePushTargetListener);
            channelHandlerListener.setConcurrentConsumers(Integer.parseInt(this.concurrency));
            channelHandlerListener.setRecoveryInterval(10000L);
            ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
            taskExecutor.setCorePoolSize(Integer.parseInt(this.initSize));
            taskExecutor.setMaxPoolSize(Integer.parseInt(this.maxSize));
            taskExecutor.setQueueCapacity(Integer.parseInt(this.capacity));
            taskExecutor.setThreadGroupName("TR-C5-A-" + destination);
            taskExecutor.setThreadNamePrefix("TR-C5-A-");
            taskExecutor.setBeanName(this.realtimePushTargetListener.getClass().getName());
            taskExecutor.afterPropertiesSet();
            channelHandlerListener.setTaskExecutor((Executor)taskExecutor);
            channelHandlerListener.setCacheLevel(3);
            channelHandlerListener.setMaxMessagesPerTask(10);
            channelHandlerListener.setIdleTaskExecutionLimit(10);
            channelHandlerListener.setBeanName("TR_" + destination);
            channelHandlerListener.afterPropertiesSet();
            channelHandlerListener.start();
        }
        return tmsChannelFactory;
    }

    public ActivemqConnectorEnviroment(RealtimeTargetListener realtimePushTargetListener) {
        this.realtimePushTargetListener = realtimePushTargetListener;
    }
}

