/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.query;

import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.query.ColumnOption;
import com.humuson.tms.trans.module.query.QueryOptimizerFactory;
import com.humuson.tms.trans.repository.model.TmsTestTargetUser;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TestQueryAssembly
extends QueryOptimizerFactory {
    private static final Logger log = LoggerFactory.getLogger(TestQueryAssembly.class);
    private ColumnOption columnOption = new ColumnOption(){

        @Override
        public String option(String channelType, String column) {
            return TestQueryAssembly.this.testTargetChange(channelType, column);
        }

        @Override
        public void ifNecessaryAddColumn(String channelType, Map<String, Object> columns) {
            TestQueryAssembly.this.ifNecessaryAddKeyPushToken(channelType, columns);
        }
    };

    public String makeSelectQueryOfTargetTempList(final String channelType, final Map<String, Object> result, final List<String> filter, List<TmsTestTargetUser> testTargetUsers) {
        if (this.defaultOptimizer == null) {
            this.setDefaultOptimizer();
        }
        String query = ((StringBuilder)new SQL(){
            {
                this.SELECT(TestQueryAssembly.this.defaultOptimizer.makeColumnListText(channelType, result, filter, new ColumnOption(){

                    @Override
                    public String option(String channelType, String column) {
                        return column;
                    }

                    @Override
                    public void ifNecessaryAddColumn(String channelType, Map<String, Object> columns) {
                    }
                }));
                this.FROM(" TMS_TARGET_TEMP ");
                this.WHERE(" GRP_SEQ=" + result.get("GRP_SEQ"));
                this.WHERE(" SEND_ID=" + result.get("SEND_ID"));
                this.WHERE(" TMS_M_ID='" + result.get("TMS_M_ID") + "'");
            }
        }.usingAppender((Appendable)new StringBuilder())).toString();
        return this.makeTestQuery(channelType, result, query, testTargetUsers);
    }

    public String makeTestQuery(final String channelType, final Map<String, Object> columns, final String limitOneQuery, List<TmsTestTargetUser> testTargetUsers) {
        if (this.defaultOptimizer == null) {
            this.setDefaultOptimizer();
        }
        String testOneQuery = ((StringBuilder)new SQL(){
            {
                this.SELECT(TestQueryAssembly.this.defaultOptimizer.makeColumnListText(channelType, columns, null, TestQueryAssembly.this.columnOption));
                this.FROM("( " + limitOneQuery + ") A");
            }
        }.usingAppender((Appendable)new StringBuilder())).toString();
        if (log.isDebugEnabled()) {
            log.debug("test query only one sql[{}]", (Object)testOneQuery);
        }
        StringBuilder sb = new StringBuilder();
        for (TmsTestTargetUser testUser : testTargetUsers) {
            sb.append("\n");
            sb.append(" SELECT \n");
            sb.append("'" + testUser.getEMAIL_ID() + "' AS EMAIL_ID , \n");
            sb.append("'" + testUser.getPHONE_NUM() + "' AS PHONE_NUM , \n");
            sb.append("'" + testUser.getPUSH_TOKEN() + "' AS PUSH_TOKEN  \n");
            sb.append(" FROM DUAL ");
            sb.append("UNION ALL");
        }
        String testListQuery = "(" + sb.toString().replaceAll("UNION ALL$", "") + ") B ";
        return testOneQuery + " , " + testListQuery;
    }

    private void ifNecessaryAddKeyPushToken(String channelType, Map<String, Object> columns) {
        if (Constants.ChannelType.PU.name().equalsIgnoreCase(channelType) && !columns.containsKey("TMS_M_TOKEN")) {
            columns.put("TMS_M_TOKEN", "");
        }
    }

    private String testTargetChange(String type, String next) {
        if (Constants.ChannelType.EM.name().equalsIgnoreCase(type) && "TMS_M_EMAIL".equalsIgnoreCase(next)) {
            return " B.EMAIL_ID AS TMS_M_EMAIL ";
        }
        if ((Constants.ChannelType.SM.name().equalsIgnoreCase(type) || Constants.ChannelType.KA.name().equalsIgnoreCase(type)) && "TMS_M_PHONE".equalsIgnoreCase(next)) {
            return " B.PHONE_NUM AS TMS_M_PHONE ";
        }
        if (Constants.ChannelType.PU.name().equalsIgnoreCase(type) && "TMS_M_TOKEN".equalsIgnoreCase(next)) {
            return " B.PUSH_TOKEN AS TMS_M_TOKEN ";
        }
        if (Constants.ChannelType.PU.name().equalsIgnoreCase(type) && "OS".equalsIgnoreCase(next)) {
            return " B.OS AS OS ";
        }
        return "A." + next;
    }
}

