/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.query;

import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcTemplate;
import com.humuson.tms.trans.module.query.ColumnOption;
import com.humuson.tms.trans.module.query.QueryOptimizer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class SimpleQueryOptimizer
implements QueryOptimizer {
    private static final Logger log = LoggerFactory.getLogger(SimpleQueryOptimizer.class);
    @Autowired
    private TmsJdbcTemplate tmsJdbcTemplate;

    @Override
    public void setDbId(int dbId) throws Exception {
        this.tmsJdbcTemplate.db(TmsBatchDataSourceManager.INSTANCE.getDataSource(dbId));
    }

    @Override
    public void close() {
        this.tmsJdbcTemplate.close();
    }

    @Override
    public String makeColumnListText(String channelType, Map<String, Object> columns, List<String> filters, ColumnOption columnOption) {
        columnOption.ifNecessaryAddColumn(channelType, columns);
        if (filters != null && !filters.isEmpty()) {
            for (String filter : filters) {
                if (!columns.containsKey(filter)) continue;
                columns.remove(filter);
            }
        }
        Set<String> keys = columns.keySet();
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            sb.append(columnOption.option(channelType, iterator.next()));
            sb.append(",");
        }
        return sb.toString().replaceAll(",$", "");
    }

    @Override
    public Map<String, Object> getColumns(String query) {
        if (this.moreThenOne(query)) {
            query = this.makeOnlyOneSql(query);
        }
        return this.tmsJdbcTemplate.selectOne(query);
    }

    public boolean moreThenOne(final String query) {
        StringBuilder sb = new StringBuilder();
        String sql = ((StringBuilder)new SQL(){
            {
                this.SELECT("COUNT(*) AS CNT");
                this.FROM("(" + query + ") A");
            }
        }.usingAppender((Appendable)sb)).toString();
        Map result = this.tmsJdbcTemplate.selectOne(sql);
        return Integer.parseInt(result.get("CNT").toString().trim()) > 1;
    }

    @Override
    public long selectCount(final String query) {
        StringBuilder sb = new StringBuilder();
        String sql = ((StringBuilder)new SQL(){
            {
                this.SELECT("COUNT(*) AS CNT");
                this.FROM("(" + query + ") A");
            }
        }.usingAppender((Appendable)sb)).toString();
        Map result = this.tmsJdbcTemplate.selectOne(sql);
        return Long.parseLong(result.get("CNT").toString());
    }
}

